% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dedup.R
\name{faers_dedup}
\alias{faers_dedup}
\alias{faers_dedup,FAERSascii-method}
\alias{faers_dedup,FAERSxml-method}
\alias{faers_dedup,ANY-method}
\title{Tidy up FAERS Quarterly Data with duplicate records removed}
\usage{
faers_dedup(object, ...)

\S4method{faers_dedup}{FAERSascii}(object, remove_deleted_cases = TRUE)

\S4method{faers_dedup}{FAERSxml}(object)

\S4method{faers_dedup}{ANY}(object)
}
\arguments{
\item{object}{A \link{FAERSascii} object.}

\item{...}{Other arguments passed to specific methods.}

\item{remove_deleted_cases}{If \code{TRUE}, will remove all
\link[=FAERS-class]{deletedCases} from the final result.}
}
\value{
A \link{FAERSascii} object.
}
\description{
Tidy up FAERS Quarterly Data with duplicate records removed
}
\examples{
# you must change `dir`, as the files included in the package are sampled
data <- faers(c(2004, 2017), c("q1", "q2"),
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
\dontrun{
# we must standardize firstly
# you should replace `meddra_path` with yours
data <- faers_standardize(data, meddra_path)
faers_dedup(data)
}
}
\seealso{
\link{faers_standardize}
}
