% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena.R
\name{athena}
\alias{athena}
\title{Read and Parse ATHENA VOCABULARIES data}
\usage{
athena(use = NULL, list = FALSE, force = FALSE, url = NULL)
}
\arguments{
\item{use}{An atomic character specifying the files to use with values in
"concept", "domain", "concept_class", "concept_relationship", "concept_ancestor", "concept_synonym", "drug_strength", "relationship", and "vocabulary".}

\item{list}{A boolean value, should it only list files in the ATHENA
VOCABULARIES data?}

\item{force}{A boolean value. If set to \code{TRUE}, it indicates the retrieval of
VOCABULARIES data in the \code{url} directly, bypassing the cache.}

\item{url}{A string of url for ATHENA VOCABULARIES data. You must provide it
to cache the file when you firstly run this function.}
}
\value{
\itemize{
\item if \code{list = TRUE}, an atomic character.
\item if \code{list = FALSE}, a \link[data.table:data.table]{data.table} if \code{use} is a
string or otherwise a list of \link[data.table:data.table]{data.table}.
}
}
\description{
Read and Parse ATHENA VOCABULARIES data
}
