% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ColorAdjustments.R
\name{Darken}
\alias{Darken}
\title{Darkens input colors by a set amount}
\usage{
Darken(colors, percent.change = 0.25, relative = TRUE)
}
\arguments{
\item{colors}{the color(s) input. Can be a list of colors, for example, \code{dittoColors(1)}.}

\item{percent.change}{# between 0 and 1. the percentage to darken by. Defaults to 0.25 if not given.}

\item{relative}{TRUE/FALSE. Whether the percentage should be a relative change versus an absolute one. Default = TRUE.}
}
\value{
Return a darkened version of the color in hexadecimal color form (="#RRGGBB" in base 16)
}
\description{
A wrapper for the darken function of the colorspace package.
}
\examples{
Darken("blue") #"blue" = "#0000FF"
#Output: "#0000BF"
Darken(dittoColors()[1:8]) #Works for multiple color inputs as well.

}
\author{
Daniel Bunis
}
