% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-getters.R
\name{isMeta}
\alias{isMeta}
\title{Tests if an input is the name of a meta.data slot in a target object.}
\usage{
isMeta(test, object, return.values = FALSE)
}
\arguments{
\item{test}{String or vector of strings, the "potential.metadata.name"(s) to check for.}

\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{return.values}{Logical which sets whether the function returns a logical \code{TRUE}/\code{FALSE} versus the \code{TRUE} \code{test} values . Default = \code{FALSE}}
}
\value{
Returns a logical or logical vector indicating whether each instance in \code{test} is a meta.data slot within the \code{object}.
Alternatively, returns the values of \code{test} that were indeed metadata slots if \code{return.values = TRUE}.
}
\description{
Tests if an input is the name of a meta.data slot in a target object.
}
\details{
For Seurat objects, also returns TRUE for the input \code{"ident"} because, for all dittoSeq visualiztions, \code{"ident"} will retrieve a Seurat objects' clustering slot.
}
\examples{
example(importDittoBulk, echo = FALSE)

# To check if something is a metadata slot
isMeta("timepoint", object = myRNA) # FTRUE
isMeta("nCount_RNA", object = myRNA) # FALSE

# To test if many things are metadata of an object
isMeta(c("age","groups"), myRNA) # FALSE, TRUE

# 'return.values' input is especially useful in these cases.
isMeta(c("age","groups"), myRNA,
    return.values = TRUE)

# Alternatively, to see all metadata slots of an object, use getMetas
getMetas(myRNA)

}
\seealso{
\code{\link{getMetas}} for returning all metadata slots of an \code{object}

\code{\link{meta}} for obtaining the contants of metadata slots
}
\author{
Daniel Bunis
}
