% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blase_data_class.R
\name{show,BlaseData-method}
\alias{show,BlaseData-method}
\title{Show an BlaseData object}
\usage{
\S4method{show}{BlaseData}(object)
}
\arguments{
\item{object}{a \link{BlaseData} object}
}
\value{
A character vector describing the BLASE object
}
\description{
Show an BlaseData object
}
\examples{
counts <- matrix(rpois(100, lambda = 10), ncol = 10, nrow = 10)
sce <- SingleCellExperiment::SingleCellExperiment(
    assays = list(normcounts = counts)
)
sce$pseudotime <- seq_len(10) - 1
data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 3)
genes(data) <- as.character(seq_len(10))

genes(data)
}
\concept{blase-object}
