% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_selection.R
\name{smooth_gene}
\alias{smooth_gene}
\title{smooth_gene}
\usage{
smooth_gene(sce, gene, pseudotime_slot = "slingPseudotime_1", knots = 10)
}
\arguments{
\item{sce}{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} to do
the calculations on.}

\item{gene}{String. The name of the gene to smooth}

\item{pseudotime_slot}{String. The slot in the
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} object metadata
containing pseudotime}

\item{knots}{Integer. The number of knots to use when fitting the GAM}
}
\value{
Smoothed Gene Expression over pseudotime
}
\description{
Returns the smoothed expression of the given gene, based on a GAM fit to
the normalised expression.
}
\examples{
ncells <- 70
ngenes <- 100
# Each gene should have mean around its gene number
counts <- c()
for (i in seq_len(ngenes)) {
    counts <- c(counts, dnorm(seq_len(ncells), mean = (ncells / i), sd = 1))
}

counts_matrix <- matrix(
    counts,
    ncol = ncells,
    nrow = ngenes
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    counts = counts_matrix * 3,
    normcounts = counts_matrix,
    logcounts = log(counts_matrix)
))
colnames(sce) <- paste0("cell", seq_len(ncells))
rownames(sce) <- paste0("gene", seq_len(ngenes))
sce$cell_type <- c(
    rep("celltype_1", ncells / 2),
    rep("celltype_2", ncells / 2)
)

sce$pseudotime <- seq_len(ncells) - 1
genelist <- rownames(sce)

# calculate_gene_peakedness
gene_peakedness <- calculate_gene_peakedness(
    sce,
    pseudotime_slot = "pseudotime"
)

head(gene_peakedness)

# plot_gene_peakedness
plot_gene_peakedness(sce, gene_peakedness, "gene20",
    pseudotime_slot = "pseudotime"
)

# smooth_gene
smoothed_gene20 <- smooth_gene(
    sce, "gene20",
    pseudotime_slot = "pseudotime"
)
head(smoothed_gene20)

# Select best spread of genes
genes_to_use <- gene_peakedness_spread_selection(sce, gene_peakedness,
    genes_per_bin = 2, n_gene_bins = 1, pseudotime_slot = "pseudotime"
)

print(genes_to_use)
plot(
    x = gene_peakedness[
        gene_peakedness$gene \%in\% genes_to_use, "peak_pseudotime"
    ],
    y = gene_peakedness[gene_peakedness$gene \%in\% genes_to_use, "ratio"]
)

}
\concept{gene-selection}
