% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadIntoMemory.R
\name{loadIntoMemory}
\alias{loadIntoMemory}
\title{Load a HDF5 matrix into memory}
\usage{
loadIntoMemory(x, force.integer = FALSE)
}
\arguments{
\item{x}{A \pkg{HDF5Array}-derived matrix or seed object.}

\item{force.integer}{Whether to force floating-point values to be integers to reduce memory consumption.}
}
\value{
An external pointer that can be used in \pkg{tatami}-based functions.
}
\description{
Load a HDF5-backed matrix into memory as an external pointer to a \pkg{tatami}-compatible representation.
This differs from the (default) behavior of \code{\link{initializeCpp}}, which only loads slices of the matrix on request.
}
\examples{
library(HDF5Array)
y <- matrix(runif(1000), ncol=20, nrow=50)
z <- as(y, "HDF5Array")
ptr <- loadIntoMemory(z)

}
\author{
Aaron Lun
}
