metadata <- S4Vectors::metadata

#============================================================================
#                                                                           #
#            context(" read_metabolon ")                                    #
#                                                                           #
#============================================================================

test_that(  "read_metabolon", {
    # Read
        file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
        object <- read_metabolon(file)
    # Test
        expect_s4_class(object, 'SummarizedExperiment')
        expect_false( 'Group'    %in% svars(object))
        expect_true('subgroup' %in% svars(object))
})

test_that(  "read_metabolon: groupvar = 'Time' ", {
    # Read
        file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
        object <- read_metabolon(file, groupvar = 'Time')
    # Test
        expect_s4_class(object, 'SummarizedExperiment')
        expect_true('subgroup' %in% svars(object))
        expect_true('Time'     %in% svars(object))
})

test_that(  "read_metabolon: pca = TRUE ", {
    # Read
        file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
        object <- read_metabolon(file, pca = TRUE)
    # Test
        expect_s4_class(object, 'SummarizedExperiment')
        expect_true(all(c('t~sample_id~pca1', 't~sample_id~pca2') %in% svars(object)))
        expect_true(all(c('t~sample_id~pca1', 't~sample_id~pca2') %in% fvars(object)))
        expect_true('sample_id~pca' %in% names(metadata(object)))
})

test_that(  "read_metabolon: fit = 'limma' ", {
    # Read
        file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
        object <- read_metabolon(file, fit = 'limma', block = 'Subject')
    # Test
        expect_s4_class(object, 'SummarizedExperiment')
        expect_true(any(stri_detect_fixed(fvars(object), '~limma')))
})

test_that(  "read_metabolon: fit = 'lm' ", {
    # Read
        file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
        object <- read_metabolon(file, fit = 'lm', block = 'Subject')
    # Test
        expect_s4_class(object, 'SummarizedExperiment')
        expect_true(any(stri_detect_fixed(fvars(object), '~lm')))
})

test_that("read_metabolon: fit = 'lme' ", {
    # Read
        file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
        object <- read_metabolon(file, block = 'Subject', fit = 'lme')
    # Test
        expect_s4_class(object, 'SummarizedExperiment')
        expect_true(any(stri_detect_fixed(fvars(object), '~lme')))
})

test_that("read_metabolon: fit = 'lmer' ",{
    # Read
        file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
        object <- suppressWarnings(read_metabolon(file, block = 'Subject', fit = 'lmer'))
    # Test
        expect_s4_class(object, 'SummarizedExperiment')
        expect_true(any(stri_detect_fixed(fvars(object), '~lmer')))
})

test_that("read_metabolon: fit = 'wilcoxon' ", {
    # Read
        file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
        object <- read_metabolon(file, block = 'Subject', fit = 'wilcoxon')
    # Test
        expect_s4_class(object, 'SummarizedExperiment')
        expect_true(any(stri_detect_fixed(fvars(object), '~wilcoxon')))
})
