% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_read_rnaseq.R
\name{weights}
\alias{weights}
\alias{weights,SummarizedExperiment-method}
\alias{weights<-}
\alias{weights<-,SummarizedExperiment,matrix-method}
\alias{weights<-,SummarizedExperiment,numeric-method}
\alias{weights<-,SummarizedExperiment,NULL-method}
\title{Get/Set weights}
\usage{
weights(object, ...)

\S4method{weights}{SummarizedExperiment}(object)

weights(object) <- value

\S4method{weights}{SummarizedExperiment,matrix}(object) <- value

\S4method{weights}{SummarizedExperiment,numeric}(object) <- value

\S4method{weights}{SummarizedExperiment,NULL}(object) <- value
}
\arguments{
\item{object}{SummarizedExperiment}

\item{...}{addtional params}

\item{value}{ratio matrix (features x samples)}
}
\value{
weight matrix (get) or updated object (set)
}
\description{
Get/Set weight matrix
}
\examples{
file <- system.file('extdata/billing19.rnacounts.txt', package = 'autonomics')
object <- read_rnaseq_counts(file)
weights(object)[1:3, 1:2]
weights(object) <- 1
weights(object)[1:3, 1:2]
}
