% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/23_impute.R
\name{impute}
\alias{impute}
\alias{impute.numeric}
\alias{impute.matrix}
\alias{impute.SummarizedExperiment}
\title{Impute}
\usage{
impute(object, ...)

\method{impute}{numeric}(object, shift = 2.5, width = 0.3, verbose = TRUE, plot = FALSE, ...)

\method{impute}{matrix}(
  object,
  shift = 2.5,
  width = 0.3,
  verbose = TRUE,
  plot = FALSE,
  n = min(9, ncol(object)),
  palette = make_colors(colnames(object)),
  ...
)

\method{impute}{SummarizedExperiment}(
  object,
  assay = assayNames(object)[1],
  by = "subgroup",
  shift = 2.5,
  width = 0.3,
  frac = 0.5,
  verbose = TRUE,
  plot = FALSE,
  palette = make_colors(colnames(object)),
  n = min(9, ncol(object)),
  ...
)
}
\arguments{
\item{object}{numeric vector, SumExp}

\item{...}{required for s3 dispatch}

\item{shift}{number: sd units}

\item{width}{number: sd units}

\item{verbose}{TRUE or FALSE}

\item{plot}{TRUE or FALSE}

\item{n}{number of samples to plot}

\item{palette}{color vector}

\item{assay}{string}

\item{by}{svar}

\item{frac}{fraction: fraction of available samples should be greater 
than this value for a subgroup to be called available}
}
\value{
numeric vector, matrix or SumExp
}
\description{
Impute NA values
}
\details{
Imputes NA values from N(mean - 2.5 sd, 0.3 sd)
}
\examples{
# Simple Design
   file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
   object <- read_maxquant_proteingroups(file)
   impute(values(object)[, 1], plot = TRUE)[1:3]              # vector
   impute(values(object),      plot = TRUE)[1:3, 1:3]         # matrix
   impute(object, plot = TRUE)                                # sumexp
# Complex Design
   subgroups <- sprintf('\%s_STD', c('E00','E01','E02','E05','E15','E30','M00'))
   file <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
   object <- read_maxquant_proteingroups(file, subgroups = subgroups)
   impute(values(object)[1:3, 1   ])     # vector
   impute(values(object)[1:3, 1:5 ])     # matrix
   impute( object )                      # sumexp
}
