% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/23_impute.R
\name{systematic_nas}
\alias{systematic_nas}
\alias{random_nas}
\alias{no_nas}
\title{Is systematic/random/full NA}
\usage{
systematic_nas(object, by = "subgroup", frac = 0.5)

random_nas(object, by = "subgroup")

no_nas(object)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{by}{svar (string)}

\item{frac}{fraction}
}
\description{
Is systematic/random/full NA
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
table(systematic_nas(object))   # missing in some subgroups, present in others
table(random_nas(object))       # missing in some samples, independent of subgroup
table(no_nas(object))           # missing in no samples
}
