% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_genes.R
\name{select_genes}
\alias{select_genes}
\alias{prefilter_angl}
\alias{extract_rows_for_unique_genes}
\title{Select genes}
\usage{
prefilter_angl(
  snr_zscore_matrix,
  mean_zscore_matrix,
  zscore_mean_threshold = 1,
  zscore_sn_threshold = 1,
  verbose = TRUE
)

select_genes(
  sce,
  zscore_mean_threshold = 2,
  zscore_sn_threshold = 2,
  max_n_genes = NULL,
  direction = "both",
  adjust_thresholds = TRUE,
  verbose = TRUE
)

extract_rows_for_unique_genes(dt, max_n_genes)
}
\arguments{
\item{snr_zscore_matrix}{A \code{bigstatsr::FBM} object containing the SNR
z-scores.}

\item{mean_zscore_matrix}{A \code{bigstatsr::FBM} object containing the mean
z-scores.}

\item{zscore_mean_threshold}{Numeric value specifying the threshold for the
absolute mean z-score. Default is 2.}

\item{zscore_sn_threshold}{Numeric value specifying the threshold for the
SNR z-score. Default is 2.}

\item{sce}{A \code{SingleCellExperiment} object.}

\item{max_n_genes}{An integer specifying the maximum number of unique genes
to return.}

\item{direction}{whether to select genes with positive, negative or both
mean z-scores. Default is "both"}

\item{adjust_thresholds}{whether to automatically adjust threholds if the
selected genes do not meet the thresholds. Default is TRUE}

\item{dt}{A data frame containing gene pairs, with columns \code{geneA}
and \code{geneB}.}
}
\value{
A data frame containing the prefiltered gene pairs.

The input \code{anglemaniaObject} with the
\code{integration_genes} slot updated to include the selected genes and
their statistical information.

A vector of unique gene identifiers.
}
\description{
Select genes from a SingleCellExperiment object based on
mean z-score and the signal-to-noise ratio of angles between gene pairs
across batches.
}
\details{
The function performs the following steps:
\enumerate{
\item Identifies gene pairs where both the mean z-score and SNR z-score
exceed the specified thresholds.
}

The function performs the following steps:
\enumerate{
\item If \code{max_n_genes} is not specified, it uses all genes that pass
the thresholds.
\item Identifies gene pairs where both the mean z-score and SNR z-score
exceed the specified thresholds.
\item If no gene pairs meet the criteria, it adjusts the thresholds to the
99th percentile values of the corresponding statistics and re-selects.
\item Extracts unique genes from the selected gene pairs using
\code{\link{extract_rows_for_unique_genes}}.
}

The function combines the \code{geneA} and \code{geneB} columns, extracts
unique gene names, and returns the first \code{max_n_genes} genes. If
\code{max_n_genes} exceeds the number of unique genes available, all unique
genes are returned.
}
\section{Functions}{
\itemize{
\item \code{prefilter_angl()}: Prefilter gene pairs from the mean and SNR z-scores
based on thresholds, to simplify downstream filtering.

\item \code{select_genes()}: Select genes from the mean and SNR z-score matrices
stored in the SCE based on thresholds for mean and SNR.

\item \code{extract_rows_for_unique_genes()}: Extract unique gene identifiers
from gene pairs, returning up to a specified maximum number.

}}
\examples{
library(SingleCellExperiment)
sce <- sce_example()
sce <- anglemania(sce, batch_key = "batch")
snr_zscore_matrix <- metadata(sce)$anglemania$list_stats$sn_zscore
mean_zscore_matrix <- metadata(sce)$anglemania$list_stats$mean_zscore
prefiltered_df <- prefilter_angl(
  snr_zscore_matrix,
  mean_zscore_matrix,
  zscore_mean_threshold = 1,
  zscore_sn_threshold = 1
)
head(prefiltered_df)
sce <- sce_example()
sce <- anglemania(
  sce,
  batch_key = "batch",
  zscore_mean_threshold = 2.5,
  zscore_sn_threshold = 2.5
)
anglemania_genes <- get_anglemania_genes(sce)
# View the selected genes and use for integration
head(anglemania_genes)
length(anglemania_genes)
# Adjust thresholds to 2 and select genes
sce <- select_genes(
  sce,
  zscore_mean_threshold = 2,
  zscore_sn_threshold = 2
)
anglemania_genes <- get_anglemania_genes(sce)
head(anglemania_genes)
length(anglemania_genes)
gene_pairs <- data.frame(
  geneA = c("Gene1", "Gene2", "Gene3", "Gene4"),
  geneB = c("Gene3", "Gene4", "Gene5", "Gene6")
)
unique_genes <- extract_rows_for_unique_genes(
  gene_pairs,
  max_n_genes = 3
)
print(unique_genes)
}
\seealso{
\code{\link{extract_rows_for_unique_genes}},
\code{\link{get_intersect_genes}}, \code{\link{get_list_stats}}

\code{\link{select_genes}}
}
\keyword{internal}
