% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/weaveWeb-methods.R
\name{weaveWeb}
\alias{weaveWeb}
\alias{weaveKEGG}
\title{Weave an AnansiWeb object}
\usage{
weaveWeb(x, ...)

weaveKEGG(x, ...)
}
\arguments{
\item{x}{input object}

\item{...}{additional arguments}
}
\value{
an \code{AnansiWeb} object, with sparse binary biadjacency matrix
with features from \code{y} as rows and features from \code{x} as columns in
\code{dictionary} slot.
}
\description{
Weave an AnansiWeb object
}
\examples{
# Setup demo tables
ec2ko <- kegg_link()[["ec2ko"]]
ec2cpd <- kegg_link()[["ec2cpd"]]

# Basic usage
weaveWeb(cpd ~ ko, link = kegg_link())
weaveWeb(x = "ko", y = "ec", link = ec2ko)
weaveWeb(ec ~ cpd, link = ec2cpd)

# A wrapper is available for kegg ko, ec and cpd data
generic <- weaveWeb(cpd ~ ko, link = kegg_link())
kegg_wrapper <- weaveKEGG(cpd ~ ko)

identical(generic, kegg_wrapper)

# The following are equivalent to transposition:
a <- weaveWeb(ko ~ cpd, link = kegg_link()) |> dictionary()
b <- weaveWeb(cpd ~ ko, link = kegg_link()) |> dictionary()

identical(a, Matrix::t(b))

}
\seealso{
\code{\link[=weaveWeb-methods]{weaveWeb-methods()}}
}
