% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingTools.R
\name{makeImages}
\alias{makeImages}
\title{Add dotplot images}
\usage{
makeImages(
  df,
  eset,
  grp.factor,
  design,
  contrast,
  colind,
  boxplot = FALSE,
  repdir = "./reports",
  extraname = NULL,
  weights = NULL,
  insert.after = 3,
  altnam = NULL,
  ...
)
}
\arguments{
\item{df}{A data.frame from calling \code{topTable}. Note that the row.names for this data.frame must
be consistent with the "eset" object. In other words, if "eset" is an \code{ExpressionSet}, then the row.names
of the data.frame must consistent with the featureNames of the \code{ExpressionSet}.}

\item{eset}{A matrix, data.frame, or \code{ExpressionSet}. If using RNA-Seq data, use \code{voom} from edgeR to create
an \code{EList} object, and then pass in the "E" list item.}

\item{grp.factor}{A factor that indicates which group ALL of the samples belong to. This will be subsetted internally,
so do not subset yourself.}

\item{design}{The design matrix used by limma or edgeR to fit the model.}

\item{contrast}{The contrast matrix used by limma or edgeR to make comparisons.}

\item{colind}{Which column of the contrast matrix are we using? In other words, for which comparison are we creating a table?}

\item{boxplot}{Boolean. If \code{TRUE}, the output HTML table will have a boxplot showing differences between groups. If
\code{FALSE} (default), the table will have dotplots.}

\item{repdir}{A directory in which to put the HTML tables. Defaults to a "reports" directory in the working directory.}

\item{extraname}{By default, the tables will go in a "reports" subdirectory, and will be named based on the column
name of the contrast that is specified by the colind argument (after replacing any spaces with an underscore). If this
will result in name collisions (e.g., a previous file will be over-written because the resulting names are the same),
then an extraname can be appended to ensure uniqueness.}

\item{weights}{Array weights, generally from \code{arrayWeights} in the limma package. These will affect the size
of the plotting symbols, to reflect the relative importance of each sample.}

\item{insert.after}{Which column should the image be inserted after? Defaults to 3.}

\item{altnam}{Normally the output file directories are generated from the colnames of the contrast matrix.
This argument can be used to over-ride the default, particularly in the case that one is computing an F-test using a
set of columns from the contrast matrix.}

\item{\dots}{Allows arbitrary arguments to be passed down to lower level functions.}
}
\value{
A list, two items. The first item is the input data.frame with the glyphs included, ready to be used with
ReportingTools to create an HTML table. The second item is a pdf of the most differentially expressed comparison. This is
useful for those who are using e.g., knitr or Sweave and want to be able to automatically insert an example dotplot
in the document to show clients what to expect.
}
\description{
A function to add dotplot glyphs and links to HTML tables
}
\details{
This function is intended to create little dotplot glyphs that can be added to an HTML table of
results from e.g., a microarray or RNA-Seq experiment, showing graphically how much the different groups
are changing. The glyphs have unlabeled axes to make them small enough to fit in an HTML table, and clicking
on a glyph will result in a new page loading with a full sized dotplot, complete with axis labels.

This function is very similar to the stock functions in the ReportingTools package, but the standard
glyphs for that package consist of a dotplot on top of a boxplot, which seems too busy to me. In addition,
for most microarray analyses there are not enough replicates to make a boxplot useful.
}
\author{
James W. MacDonald \email{jmacdon@u.washington.edu}
}
