% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingTools.R
\name{entrezLinks}
\alias{entrezLinks}
\alias{affyLinks}
\alias{goLinks}
\alias{nuccoreLinks}
\alias{ensemblLinks}
\title{Add links to data when using ReportingTools}
\usage{
entrezLinks(df, ...)
}
\arguments{
\item{df}{A data.frame, usually created using the \code{select} function of
the AnnotationDbi package. For Entrez ID data, the column name must be
ENTREZID. For Affy data, the column name must be PROBEID, and for GO data
the column name must be Term. For Nuccore the column name can be any of
"GI", "REFSEQ", "ACCNUM". Any other names will fail.}

\item{...}{Allows one to pass arbitrary arguments to lower level functions.
Currently unsupported.}
}
\value{
A data.frame is returned, with links included.
}
\description{
These functions are intended to add links to the Affymetrix, Entrez Gene, Nuccore,
and AmiGO databases when creating HTML tables using ReportingTools.
}
\details{
These functions are not actually intended to be called directly. Instead,
they are used as targets for the .modifyDF argument of the \code{publish}
function of ReportingTools. See the example below for more detail.
}
\examples{

\dontrun{
## say we have an ExpressionSet from HuGene 1.0 ST array
dat <- read.celfiles()
eset <- rma(dat)
## annotate the ExpressionSet
eset <- annotateEset(eset, hugene10sttranscriptcluster.db,
columns = c("ENTREZID","ACCNUM","SYMBOL"))
## and fit a model using limma
fit <- lmFit(eset, design)
fit2 <- eBayes(fit)
## and create an HTML page with links to Affy and Entrez
out <- topTable(fit2, coef=2)
htab <- HTMLReport("The title","a_short_name")
publish(out, htab, .modifyDF = list(affyLinks, entrezLinks, nuccoreLinks))
finish(htab)}

}
\author{
James W. MacDonald \email{jmacdon@u.washington.edu}
}
\keyword{manip}
