% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{st_invert_y}
\alias{st_invert_y}
\title{Flip the Y-axis of cell or nucleus segmentations to align with H&E image}
\usage{
st_invert_y(sf, type = c("POINT", "POLYGON"), img_height, scalef)
}
\arguments{
\item{sf}{\code{sf} an \code{sf} class object read from a \code{.geojson} file.}

\item{type}{\code{character(1)} "POINT" for cell centroid, or "POLYGON" for cell
segmentation mask. Default is "POINT".}

\item{img_height}{\code{numeric(1)} The total length along the Y axis of the
image. Obtained by reading in \code{hires} or \code{lowre}s \code{.png} under \verb{/spatial}
folder with \code{magick::image_read()}.}

\item{scalef}{\code{numeric(1)} The scaling factor from a
\verb{/spatial/scalefactors_json.json} file}
}
\value{
an \code{sf} object with Y-axis of the points or polygons flipped
}
\description{
This function flips the Y-axis of cell or nucleus segmentations
stored in an \code{sf} object to align with the H&E image. The Y-axis flipping
is necessary because the origin (0,0) in image coordinates is at the
top-left corner, while in Cartesian coordinates, the origin is at the
bottom-left corner. The function takes into account the image height and
scaling factor to accurately flip the Y-coordinates of the segmentations.
}
\examples{
geojson_file <- system.file(
    file.path("extdata", "segmented_outputs", "cell_segmentations.geojson"),
    mustWork = TRUE, package = "VisiumIO"
)
geo_data <- sf::st_read(geojson_file, quiet = TRUE)
st_invert_y(
    sf = geo_data, type = "POLYGON", img_height = 3886, scalef = 0.079
)
}
\author{
Estella YiXing Dong
}
