% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyRecurrentRegions.R
\name{identifyRecurrentRegions}
\alias{identifyRecurrentRegions}
\title{Identify recurrent genomic regions across samples}
\usage{
identifyRecurrentRegions(
  df,
  ID_col = "ID",
  error_threshold = 100,
  min_support = 3
)
}
\arguments{
\item{df}{A data.frame with columns:
\itemize{
\item ID: Sample identifier.
\item seqnames: Chromosome name.
\item start: Start coordinate of the region.
\item end: End coordinate of the region.
\item n_mendelian_error: Number of Mendelian errors in the region.
}}

\item{ID_col}{Character string indicating the column name containing
sample identifiers. Default is \code{"ID"}.}

\item{error_threshold}{Numeric, default = 100.
Maximum number of Mendelian errors allowed for a region to be considered.}

\item{min_support}{Integer, default = 3.
Minimum number of unique samples required to call a region recurrent.}
}
\value{
A GRanges object containing the recurrent regions that meet
the minimum support threshold.
}
\description{
This function finds recurrent genomic regions across samples based on overlapping intervals.
Regions exceeding the Mendelian error threshold are excluded.
}
\examples{
df <- data.frame(
ID = c("S1", "S2", "S3", "S3"),
seqnames = c("chr1", "chr1", "chr1", "chr1"),
start = c(100, 120, 500, 510),
end = c(150, 170, 550, 560),
n_mendelian_error = c(10, 20, 5, 5)
)
identifyRecurrentRegions(df, ID_col = "ID", error_threshold = 50, min_support = 2)
}
