% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{u_stat_signature_list}
\alias{u_stat_signature_list}
\title{Calculate U scores for a list of signatures, given a rank matrix}
\usage{
u_stat_signature_list(
  sig_list,
  ranks_matrix,
  maxRank = 1500,
  sparse = FALSE,
  w_neg = 1,
  missing_genes = "impute"
)
}
\arguments{
\item{sig_list}{A list of signatures}

\item{ranks_matrix}{Matrix of pre-computed ranks}

\item{maxRank}{Max number of features to include in ranking,
for u_stat function}

\item{sparse}{Whether the vector of ranks is in sparse format}

\item{w_neg}{Weight on negative signatures}

\item{missing_genes}{How to handle missing genes in signatures}
}
\value{
A matrix of U scores
}
\description{
Calculate U scores for a list of signatures, given a rank matrix
}
