% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrIdent-package.R
\docType{package}
\name{TrIdent-package}
\alias{TrIdent}
\alias{TrIdent-package}
\title{\bold{TrIdent} - \bold{Tr}ansduction \bold{Ident}ification}
\description{
Automatic detection, classification and characterization of
  transduction events in transductomics datasets using read coverage
  pattern-matching.

  Please see [Transductomics: sequencing-based detection and analysis of transduced DNA in pure cultures and microbial communities] (
  https://microbiomejournal.biomedcentral.com/articles/10.1186/s40168-020-00935-5)
  for more information on the transductomics method, data and analysis
  workflow.
}
\details{
The three main functions in TrIdent are:
\enumerate{
\item \code{\link{TrIdentClassifier}} performs the pattern-matching,
classification and characterization of read coverage patterns on contigs.
\item \code{\link{plotTrIdentResults}} plots the results from
 \code{TrIdentClassifier()}
\item \code{\link{specializedTransductionID}} searches contigs classified as
Prophage-like
by \code{TrIdentClassifier()} for potential specialized transduction
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/jlmaier12/TrIdent}
  \item \url{https://jlmaier12.github.io/TrIdent/}
  \item Report bugs at \url{https://github.com/jlmaier12/TrIdent/issues}
}

}
\author{
Jessie Maier \email{jlmaier@ncsu.edu} & Jorden Rabasco
  \email{jrabasc@ncsu.edu}
}
\keyword{internal}
