% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recomputeSupercells.R
\name{recomputeSupercells}
\alias{recomputeSupercells}
\title{Recompute supercells}
\usage{
recomputeSupercells(
  dt,
  sc_objects,
  markers,
  sample_colname,
  cell_id_colname,
  aggregation_method = c("mean", "median"),
  gam = 20
)
}
\arguments{
\item{dt}{A \pkg{data.table} object containing cytometry data where rows
represent cells and columns represent markers.}

\item{sc_objects}{The \code{supercell_object} returned by
\code{\link[=runSuperCellCyto]{runSuperCellCyto()}} function.}

\item{markers}{A character vector identifying the markers to create
supercells with.}

\item{sample_colname}{A character string identifying the column in
\code{dt} that denotes the sample of a cell.}

\item{cell_id_colname}{A character string identifying the column in
\code{dt} representing each cell's unique ID.}

\item{aggregation_method}{A character string indicating how to aggregate
the cells in supercells to get expression matrix.
Options are "mean" or "median". Defaults to "mean".
If "mean", the mean of the marker expressions across all cells
within each individual supercell is computed.
If "median", the median of the marker expressions across all cells
within each individual supercell is computed.}

\item{gam}{A numeric value specifying the gamma value which regulates
the number of supercells generated.
Defaults to 20.}
}
\value{
A list with the following components:
\itemize{
\item \code{supercell_expression_matrix}:  A \pkg{data.table} object that contains
the marker expression for each supercell.
These marker expressions are computed by calculating the mean of the marker
expressions across all cells
within each individual supercell.
\item \code{supercell_cell_map}: A \pkg{data.table} that maps each cell to its
corresponding supercell.
This table is essential for identifying the specific supercell each cell has
been allocated to.
It proves particularly useful for analyses that require one to expand the
supercells to the individual cell level.
}
}
\description{
Given a supercell object, recreate the supercells using a different
gamma value.

Gamma value controls the number of supercells generated.
The smaller the value, the more supercells you get, and vice versa.

For this function to run, you need to have at least run
\code{\link[=runSuperCellCyto]{runSuperCellCyto()}} function \strong{once}!
}
\examples{
set.seed(42)
cyto_dat <- simCytoData(10, rep(1000, 3))
markers <- paste0("Marker_", seq_len(10))
out_gam20 <- runSuperCellCyto(
    dt = cyto_dat,
    markers = markers,
    sample_colname = "Sample",
    cell_id_colname = "Cell_Id",
    gam = 20
)
recomputed_sc <- recomputeSupercells(
    dt = cyto_dat,
    sc_objects = out_gam20$supercell_object,
    markers = markers,
    sample_colname = "Sample",
    cell_id_colname = "Cell_Id",
    gam = 50
)

}
\author{
Givanna Putri
}
