## ----global_options, include = FALSE------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----simulate_and_cluster-----------------------------------------------------
library(SuperCellCyto)

set.seed(42)

# Simulate some data
dat <- simCytoData()
markers_col <- paste0("Marker_", seq_len(10))
cell_id_col <- "Cell_Id"

# Run kmeans
clust <- kmeans(
    x = dat[, markers_col, with = FALSE],
    centers = 5
)

clust_col <- "kmeans_clusters"
dat[[clust_col]] <- paste0("cluster_", clust$cluster)

## ----run_supercellcyto_stratified---------------------------------------------
supercells <- runSuperCellCyto(
    dt = dat,
    markers = markers_col,
    sample_colname = clust_col,
    cell_id_colname = cell_id_col
)

## ----inspect_supercell_matrix-------------------------------------------------
# Inspect the top 3 and bottom 3 of the expression matrix and some columns.
rbind(
    head(supercells$supercell_expression_matrix, n = 3),
    tail(supercells$supercell_expression_matrix, n = 3)
)[, c("kmeans_clusters", "SuperCellId", "Marker_10")]

## ----cells_per_cluster--------------------------------------------------------
# Compute how many cells per cluster, and divide by 20, the gamma value.
table(dat$kmeans_clusters) / 20

## ----supercells_per_cluster---------------------------------------------------
table(supercells$supercell_expression_matrix$kmeans_clusters)

## ----session_info-------------------------------------------------------------
sessionInfo()

