% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Structstrings-StructuredXStringSet.R
\docType{class}
\name{StructuredXStringSet}
\alias{StructuredXStringSet}
\alias{StructuredRNAStringSet}
\alias{dotbracket}
\alias{writeStructuredXStringSet}
\alias{readStructuredRNAStringSet}
\alias{StructuredRNAStringSet-class}
\alias{dotbracket<-}
\alias{dotbracket,StructuredXStringSet-method}
\alias{dotbracket<-,StructuredXStringSet-method}
\alias{getBasePairing,StructuredXStringSet-method}
\alias{getLoopIndices,StructuredXStringSet-method}
\title{StructuredRNAStringSet for storing DotBracketAnnotation alongside 
nucleotide sequences}
\usage{
StructuredRNAStringSet(x, structure)

dotbracket(x)

dotbracket(x) <- value

\S4method{dotbracket}{StructuredXStringSet}(x)

\S4method{dotbracket}{StructuredXStringSet}(x) <- value

readStructuredRNAStringSet(
  filepath,
  nrec = -1L,
  skip = 0L,
  seek.first.rec = FALSE,
  use.names = TRUE
)

writeStructuredXStringSet(x, filepath, append = FALSE, compress = FALSE, ...)

\S4method{getBasePairing}{StructuredXStringSet}(x, compress = TRUE, return.sequence = FALSE)

\S4method{getLoopIndices}{StructuredXStringSet}(x, bracket.type, warn.type.drops = TRUE)
}
\arguments{
\item{x}{For the \code{Structured*StringSet} constructors: Either a character
vector, or an \code{RNAString}, \code{RNAStringSet} object. 
For \code{writeStructuredXStringSet}: A \code{StructuredRNAStringSet} 
derivative.}

\item{structure, value}{A \code{\link{DotBracketStringSet}}}

\item{use.names, type, filepath, nrec, skip, seek.first.rec, append, ...}{See \code{\link{DotBracketStringSet-io}}}

\item{compress}{See \code{\link{getBasePairing}} or
\code{\link{DotBracketStringSet-io}}}

\item{return.sequence}{\code{TRUE}(default) or \code{FALSE}: Whether the 
sequence should be returned in the \code{base} column.}

\item{bracket.type}{\code{getLoopIndices}: Which dot bracket annotation type 
should be converted into loop indices? Only usable, if more than one is 
present.
(\code{1L = '()', 2L = '<>', 3L = '[]', 4L = '{}'})}

\item{warn.type.drops}{See \code{\link{getLoopIndices}}}
}
\value{
a \code{StructuredRNAStringSet} object.
}
\description{
The \code{\link{StructuredXStringSet}} class can be used to store structure 
information alongside RNA sequences. The class behaves like the 
\code{\link[Biostrings:QualityScaledXStringSet-class]{QualityScaledXStringSet}}
classes.

Please note, that this does not check for validity regarding base pairing 
capabilities.
}
\details{
the \code{dotbracket} function allows access to the included 
\code{\link{DotBracketStringSet}}.
}
\examples{
str <- DotBracketStringSet("(())")
seq <- RNAStringSet("AGCU")
sdbs <- StructuredRNAStringSet(seq,str)
}
