% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{readPolygonsXenium}
\alias{readPolygonsXenium}
\title{readPolygonsXenium}
\usage{
readPolygonsXenium(
  polygonsFile,
  type = c("parquet", "csv"),
  x = "vertex_x",
  y = "vertex_y",
  keepMultiPol = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{polygonsFile}{A character string specifying the file path to the
polygon data.}

\item{type}{A character string specifying the file type ("parquet" or "csv").
Default is parquet.}

\item{x}{A character string specifying the x-coordinate column.}

\item{y}{A character string specifying the y-coordinate column.}

\item{keepMultiPol}{A logical value indicating whether to keep multipolygons.}

\item{verbose}{A logical value indicating whether to print additional
information.}
}
\value{
An `sf` object containing the Xenium polygon data.
}
\description{
This function reads polygon data specific to Xenium technology.
}
\examples{
example(readXeniumSPE)
polygons <- readPolygonsXenium(metadata(spe)$polygons, type="parquet")
polygons
}
