% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainSpaNorm.R
\name{SpaNorm}
\alias{SpaNorm}
\alias{SpaNorm,SpatialExperiment-method}
\title{Spatially-dependent normalisation for spatial transcriptomics data}
\usage{
SpaNorm(
  spe,
  sample.p = 0.25,
  gene.model = c("nb"),
  adj.method = c("auto", "logpac", "pearson", "medbio", "meanbio"),
  scale.factor = 1,
  df.tps = 6,
  lambda.a = 1e-04,
  batch = NULL,
  tol = 1e-04,
  step.factor = 0.5,
  maxit.nb = 50,
  maxit.psi = 25,
  maxn.psi = 500,
  overwrite = FALSE,
  verbose = TRUE,
  ...
)

\S4method{SpaNorm}{SpatialExperiment}(
  spe,
  sample.p = 0.25,
  gene.model = c("nb"),
  adj.method = c("auto", "logpac", "pearson", "medbio", "meanbio"),
  scale.factor = 1,
  df.tps = 6,
  lambda.a = 1e-04,
  batch = NULL,
  tol = 1e-04,
  step.factor = 0.5,
  maxit.nb = 50,
  maxit.psi = 25,
  maxn.psi = 500,
  overwrite = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{spe}{a SpatialExperiment or Seurat object, with the count data stored in 'counts' or 'data' assays respectively.}

\item{sample.p}{a numeric, specifying the (maximum) proportion of cells/spots to sample for model fitting (default is 0.25).}

\item{gene.model}{a character, specifying the model to use for gene/protein abundances (default 'nb'). This should be 'nb' for count based datasets.}

\item{adj.method}{a character, specifying the method to use to adjust the data (default 'auto', see details)}

\item{scale.factor}{a numeric, specifying the sample-specific scaling factor to scale the adjusted count.}

\item{df.tps}{a numeric, specifying the degrees of freedom for the thin-plate spline (default is 6).}

\item{lambda.a}{a numeric, specifying the smoothing parameter for regularizing regression coefficients (default is 0.0001). Actual lambda.a used is lambda.a * ncol(spe).}

\item{batch}{a vector or numeric matrix, specifying the batch design to regress out (default NULL, representing no batch effects). See details for more information on how to define this variable.}

\item{tol}{a numeric, specifying the tolerance for convergence (default is 1e-4).}

\item{step.factor}{a numeric, specifying the multiplicative factor to decrease IRLS step by when log-likelihood diverges (default is 0.5).}

\item{maxit.nb}{a numeric, specifying the maximum number of IRLS iteration for estimating NB mean parameters for a given dispersion parameter (default is 50).}

\item{maxit.psi}{a numeric, specifying the maximum number of IRLS iterations to estimate the dispersion parameter (default is 25).}

\item{maxn.psi}{a numeric, specifying the maximum number of cells/spots to sample for dispersion estimation (default is 500).}

\item{overwrite}{a logical, specifying whether to force recomputation and overwrite an existing fit (default FALSE). Note that if df.tps, batch, lambda.a, or gene.model are changed, the model is recomputed and overwritten.}

\item{verbose}{a logical, specifying whether to show update messages (default TRUE).}

\item{...}{other parameters fitting parameters.}
}
\value{
a SpatialExperiment or Seurat object with the adjusted data stored in 'logcounts' or 'data', respectively.
}
\description{
Performs normalisation of spatial transcriptomics data using spatially-dependent spot- and gene- specific size factors.
}
\details{
SpaNorm works by first fitting a spatial regression model for library size to the data. Normalised data can then be computed using various adjustment approaches. When a negative binomial gene-model is used, the data can be adjusted using the following approaches: 'logpac', 'pearson', 'medbio', and 'meanbio'.

Batch effects can be specified using the \code{batch} parameter. If this parameter is a vector, a design matrix will be created within the function using \code{model.matrix}. If a custom design is provided in the form of a numeric matrix, this should ideally be created using \code{model.matrix}. The batch matrix should be created with an intercept term. The SpaNorm function will automatically detect the intercept term and remove the relevant column. Alternatively, users can subset the model matrix to remove this column manually. Please note that the model formula should include the intercept term and that the intercept column should be subset out after.
}
\examples{
data(HumanDLPFC)
\donttest{
SpaNorm(HumanDLPFC, sample.p = 0.05, df.tps = 2, tol = 1e-2)
}
}
