% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSRNet-class.R, R/SCSRNoNet-class.R
\name{getAutocrines}
\alias{getAutocrines}
\alias{getAutocrines,SCSRNet-method}
\alias{getAutocrines,SCSRNoNet-method}
\title{Method to retrieve autocrine interactions}
\usage{
\S4method{getAutocrines}{SCSRNet}(obj, pop)

\S4method{getAutocrines}{SCSRNoNet}(obj, pop)
}
\arguments{
\item{obj}{A SCSRNoNet object.}

\item{pop}{Name of the cell population whose autocrine
ligand-receptor interactions should be retrieved.}
}
\value{
A BSRInferenceComp object.

A data.frame.
}
\description{
Method to retrieve autocrine interactions

Method to retrieve autocrine interactions
}
\details{
A  \code{\link[BulkSignalR]{BSRInferenceComp-class}} object is returned that
contains all the inferred (unfiltered) interactions.

Interactions in tabular format can be obtained applying the
\code{\link[BulkSignalR]{LRinter}} accessor to the returned object. All
the BSRInferenceComp methods to reduce pathway, ligand, or receptor
redundancies can also be applied to the return object.

A  data.frame is returned that
contains the inferred interactions.
}
\examples{
print("getAutocrines")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrcn <- SCSRNet(mat,
    normalize = FALSE, method = "log-only",
    log.transformed = TRUE, populations = pop
)
if(FALSE){
# infer ligand-receptor interactions from the comparison

scsrcn <- performInferences(scsrcn,
verbose = TRUE, min.logFC = 1e-10,
max.pval = 1)

getAutocrines(scsrcn, "pop_1")
}
print("getAutocrines")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrnn <- SCSRNoNet(mat,
    normalize = FALSE, method = "log-only",
    log.transformed = TRUE, populations = pop
)
if(FALSE){
# infer ligand-receptor interactions from the comparison

scsrnn <- performInferences(scsrnn,
    verbose = TRUE, ,
    min.logFC = 1e-10, max.pval = 1)

getAutocrines(scsrcn, "pop_1")
}
}
