% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-encode.R
\name{cal_lisa_f1}
\alias{cal_lisa_f1}
\alias{cal_lisa_f1,SingleCellExperiment-method}
\alias{cal_lisa_f1,SingleCellExperiment}
\title{calculate the F1 value based on LISA result in the specified category.}
\usage{
cal_lisa_f1(data, lisa.res, type = "High", group.by, rm.group.nm = NULL, ...)

\S4method{cal_lisa_f1}{SingleCellExperiment}(data, lisa.res, type = "High", group.by, rm.group.nm = NULL, ...)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object}

\item{lisa.res}{list the result of \code{runLISA} or \code{runLOCALBV}.}

\item{type}{character the type of \code{cluster.test} column of result of \code{runLISA} or
\code{runLOCALBV}, default is \code{'High'}.}

\item{group.by}{character a specified category column names (for example the cluster column name) of
\code{colData(data)}. Or a vector of length equal to \code{ncol(data)}, specifying the group to
which each cell is assigned. It is required.}

\item{rm.group.nm}{character which want to remove some group type names from the names of
the specified category group, default is NULL.}

\item{...}{currently meaningless.}
}
\value{
a data.frame object containing the F1 value for each category in \code{group.by}.
}
\description{
this is to calculate the F1 value based on LISA result in some spatial domain.
If a feature has a larger F1 value in a spatial domain, it means the feature
is more concentrated in that spatial domain (specified category).
}
\examples{
data(hpda_spe_cell_dec)
lisa.res1 <- hpda_spe_cell_dec |> 
   runLISA(
     features = rownames(hpda_spe_cell_dec), 
     assay.type = 1
   )
res <- cal_lisa_f1(hpda_spe_cell_dec, lisa.res1, type='High', group.by = 'cluster_domain')
head(res)
# group.by, a vector of length equal to the ncol(data).
res2 <- cal_lisa_f1(hpda_spe_cell_dec, 
                    lisa.res1, 
                    type='High', 
                    group.by = hpda_spe_cell_dec$cluster_domain
  )
identical(res, res2)
}
