% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_summary_distances_between_celltypes.R
\name{calculate_summary_distances_between_celltypes}
\alias{calculate_summary_distances_between_celltypes}
\title{calculate_summary_distances_between_celltypes}
\usage{
calculate_summary_distances_between_celltypes(df)
}
\arguments{
\item{df}{Data.frame containing the distance output between cell types. The
functions that generate the distances can be
\code{\link{calculate_minimum_distances_between_celltypes}} and
\code{\link{calculate_pairwise_distances_between_celltypes}}.}
}
\value{
A data frame is returned
}
\description{
Returns the mean, median and standard deviation of the
 minimum/pairwise distances between phenotypes.
}
\examples{
# for pairwise dist
pairwise_dist <- calculate_pairwise_distances_between_celltypes(
SPIAT::defined_image, cell_types_of_interest = c("Tumour","Immune1"), 
feature_colname = "Cell.Type")
summary_distances <- calculate_summary_distances_between_celltypes(pairwise_dist)

# for minimum dist
min_dists <- calculate_minimum_distances_between_celltypes(
SPIAT::defined_image, cell_types_of_interest = c("Tumour","Immune1"), 
feature_colname = "Cell.Type")
summary_distances <- calculate_summary_distances_between_celltypes(min_dists)
}
