% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_cell_proportions.R
\name{calculate_cell_proportions}
\alias{calculate_cell_proportions}
\title{calculate_cell_proportions}
\usage{
calculate_cell_proportions(
  spe_object,
  reference_celltypes = NULL,
  celltypes_to_exclude = NULL,
  feature_colname = "Phenotype",
  plot.image = TRUE
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{reference_celltypes}{String Vector specifying reference cell types. If
NULL (default), then the proportion of each cell type against all cells is
returned. Alternatively, a custom vector of cell types can be used as
input, and these will be used as the denominator in the calculation of the
proportions.}

\item{celltypes_to_exclude}{String Vector specifying cell types to exclude.
For example "OTHER" will exclude that celltype from the Total. If NULL, all
cell types are included.}

\item{feature_colname}{String. Column of cells to choose the cell type from
(e.g. Phenotype, Cell.Type, etc).}

\item{plot.image}{Boolean. Whether to plot the barplot of the cell percentages.
By default is TRUE.}
}
\value{
A data.frame is returned
}
\description{
Calculates the number and proportion of each cell type.
}
\examples{
calculate_cell_proportions(SPIAT::defined_image, reference_celltypes = NULL, 
celltypes_to_exclude = "Others", feature_colname="Cell.Type", plot.image = FALSE)
}
