% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_nearest_neighbor_index.R
\name{average_nearest_neighbor_index}
\alias{average_nearest_neighbor_index}
\title{Average nearest neighbor index for point pattern (clustering or dispersion)}
\usage{
average_nearest_neighbor_index(
  spe_object,
  reference_celltypes,
  feature_colname,
  p_val = 5e-06
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{reference_celltypes}{String Vector. Cells with these cell types will be
used for ANNI calculation.}

\item{feature_colname}{String. Specify the selected column for
`reference_celltypes`.}

\item{p_val}{Numeric. The p value threshold to determine the significance of
a pattern.}
}
\value{
A list with the ANN index, the pattern type and the corresponding p
  value
}
\description{
Calculate the the average nearest neighbor (ANN) index of a
  specified type of cells. The index indicates the clustering effect of a
  point pattern. The pattern can be clustering, random or dispersion.
}
\details{
ANN index is a statistical test to test for the presence of clusters
  of cells, (Clark and Evans, 1954). The ANN index evaluates the spatial
  aggregation or dispersion effect of objects based on the average distances
  between pairs of the nearest objects and can be used to test for the
  clustering of specific cell types (e.g. immune or tumor cells). Next, the z
  score and p-value of the ANN index is calculated to validate the
  significance of the pattern.
}
\examples{
average_nearest_neighbor_index(SPIAT::defined_image, reference_celltypes =
"Tumour", feature_colname = "Cell.Type")
}
