% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.import.R
\name{getSBSCounts}
\alias{getSBSCounts}
\title{getSBSCounts}
\usage{
getSBSCounts(data, reference = NULL)
}
\arguments{
\item{data}{A data.frame with variants having 6 columns: sample name, chromosome, start position, end position, ref, alt.}

\item{reference}{A BSgenome object with the reference genome to be used to retrieve flanking bases.}
}
\value{
A matrix with Single Base Substitutions (SBS) counts per patient.
}
\description{
Create Single Base Substitutions (SBS) counts matrix from input data for a provided reference genome.
}
\examples{
library('BSgenome.Hsapiens.1000genomes.hs37d5')
data(ssm560_reduced)
res <- getSBSCounts(data = ssm560_reduced, reference = BSgenome.Hsapiens.1000genomes.hs37d5)

}
