% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateComputePoolSyntheticAncestryGr}
\alias{validateComputePoolSyntheticAncestryGr}
\title{Validate input parameters for computePoolSyntheticAncestryGr()
function}
\usage{
validateComputePoolSyntheticAncestryGr(
  gdsProfile,
  sampleRM,
  spRef,
  studyIDSyn,
  np,
  listCatPop,
  fieldPopInfAnc,
  kList,
  pcaList,
  algorithm,
  eigenCount,
  missingRate,
  verbose
)
}
\arguments{
\item{gdsProfile}{an object of class
\code{\link[SNPRelate:SNPGDSFileClass]{SNPRelate::SNPGDSFileClass}}, the
opened Profile GDS file.}

\item{sampleRM}{a \code{vector} of \code{character} strings representing
the identifiers of the population reference samples that should not
be used to create the reference PCA.}

\item{spRef}{a \code{vector} of \code{character} strings representing the
known super population ancestry for the population reference profiles.
The population reference profile
identifiers are used as names for the \code{vector}.}

\item{studyIDSyn}{a \code{character} string corresponding to the study
identifier.
The study identifier must be present in the GDS Sample file.}

\item{np}{a single positive \code{integer} representing the number of
threads.}

\item{listCatPop}{a \code{vector} of \code{character} string
representing the list of possible ancestry assignations.}

\item{fieldPopInfAnc}{a \code{character} string representing the name of
the column that will contain the inferred ancestry for the specified
dataset.}

\item{kList}{a \code{vector} of \code{integer} representing  the list of
values tested for the  \emph{K} parameter. The \emph{K} parameter represents the
number of neighbors used in the K-nearest neighbor analysis.}

\item{pcaList}{a \code{vector} of \code{integer} representing  the list of
values tested for the  \emph{D} parameter. The \emph{D} parameter represents the
number of dimensions used in the PCA analysis.}

\item{algorithm}{a \code{character} string representing the algorithm used
to calculate the PCA. The 2 choices are "exact" (traditional exact
calculation) and "randomized" (fast PCA with randomized algorithm
introduced in Galinsky et al. 2016).}

\item{eigenCount}{a single \code{integer} indicating the number of
eigenvectors that will be in the output of the \link[SNPRelate]{snpgdsPCA}
function; if 'eigenCount' <= 0, then all eigenvectors are returned.}

\item{missingRate}{a \code{numeric} value representing the threshold
missing rate at with the SNVs are discarded; the SNVs are retained in the
\link[SNPRelate]{snpgdsPCA} only
with "<= missingRate" only; if \code{NaN}, no missing threshold.}

\item{verbose}{a \code{logical} indicating if message information should be
printed.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{computePoolSyntheticAncestryGr}} function.
}
\examples{

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## The Profile GDS (opened)
gdsSample <- openfn.gds(file.path(dataDir,
                    "GDS_Sample_with_study_demo.gds"), readonly=TRUE)

## The known super population ancestry for the population reference profiles
spRef <- c("EUR", "SAS", "EAS", "EUR", "AFR")
names(spRef) <- c("HG00100", "HG00101", "HG00102", "HG00103", "HG00104")

## The validation should be successful
RAIDS:::validateComputePoolSyntheticAncestryGr(gdsProfile=gdsSample,
     sampleRM="TGCA_01", spRef=spRef,
     studyIDSyn="TCGA", np=1L, listCatPop=c("AFR", "EAS", "SAS"),
     fieldPopInfAnc="Pop", kList=seq_len(3),
     pcaList=seq_len(10), algorithm="exact", eigenCount=12L,
     missingRate=0.02, verbose=FALSE)

## All GDS file must be closed
closefn.gds(gdsfile=gdsSample)

}
\references{
Galinsky KJ, Bhatia G, Loh PR, Georgiev S, Mukherjee S, Patterson NJ,
Price AL. Fast Principal-Component Analysis Reveals Convergent Evolution
of ADH1B in Europe and East Asia. Am J Hum Genet. 2016 Mar 3;98(3):456-72.
doi: 10.1016/j.ajhg.2015.12.022. Epub 2016 Feb 25.
}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
