% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateComputePCARefSample}
\alias{validateComputePCARefSample}
\title{Validate input parameters for computePCARefSample() function}
\usage{
validateComputePCARefSample(
  gdsProfile,
  currentProfile,
  studyIDRef,
  np,
  algorithm,
  eigenCount,
  missingRate,
  verbose
)
}
\arguments{
\item{gdsProfile}{an object of class \link[gdsfmt]{gds.class},
an opened Profile GDS file.}

\item{currentProfile}{a single \code{character} string representing the
profile identifier.}

\item{studyIDRef}{a single \code{character} string representing the
study identifier.}

\item{np}{a single positive \code{integer} representing the number of CPU
that will be used.}

\item{algorithm}{a \code{character} string representing the algorithm used
to calculate the PCA.}

\item{eigenCount}{a single \code{integer} indicating the number of
eigenvectors that will be in the output of the \link[SNPRelate]{snpgdsPCA}
function; if 'eigen.cnt' <= 0, then all eigenvectors are returned.}

\item{missingRate}{a \code{numeric} value representing the threshold
missing rate at with the SNVs are discarded; if \code{NaN}, no missing
threshold.}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{computePCARefSample}} function.
}
\examples{

## Required library
library(gdsfmt)

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## The GDS Sample (opened)
gdsSample <- openfn.gds(file.path(dataDir,
                    "GDS_Sample_with_study_demo.gds"), readonly=TRUE)

## The validation should be successful
RAIDS:::validateComputePCARefSample(gdsProfile=gdsSample,
    currentProfile="HCC01", studyIDRef="1KG", np=1L, algorithm="exact",
    eigenCount=32L, missingRate=0.02, verbose=FALSE)

## All GDS file must be closed
closefn.gds(gdsfile=gdsSample)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
