% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateComputeKNNRefSample}
\alias{validateComputeKNNRefSample}
\title{Validate the input parameters for computeKNNRefSample()
function}
\usage{
validateComputeKNNRefSample(
  listEigenvector,
  listCatPop,
  spRef,
  fieldPopInfAnc,
  kList,
  pcaList
)
}
\arguments{
\item{listEigenvector}{a \code{list} with 3 entries:
'sample.id', 'eigenvector.ref' and 'eigenvector'. The \code{list} represents
the PCA done on the 1KG reference profiles and the specific profile
projected onto it. The 'sample.id' entry must contain only one identifier
(one profile).}

\item{listCatPop}{a \code{vector} of \code{character} string
representing the list of possible ancestry assignations.}

\item{spRef}{\code{vector} of \code{character} strings representing the
known super population ancestry for the 1KG profiles. The 1KG profile
identifiers are used as names for the \code{vector}.}

\item{fieldPopInfAnc}{a \code{character} string representing the name of
the column that will contain the inferred ancestry for the specified
dataset.}

\item{kList}{a \code{vector} of \code{integer} representing  the list of
values tested for the  K parameter. The K parameter represents the
number of neighbors used in the K-nearest neighbors analysis.}

\item{pcaList}{a \code{vector} of \code{integer} representing  the list of
values tested for the  D parameter. The D parameter represents the
number of dimensions used in the PCA analysis.}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function validates the input parameters for the
\code{\link{computeKNNRefSample}} function.
When a parameter is not as expected, an error message is generated.
}
\examples{

## Load the demo PCA on the synthetic profiles projected on the
## demo 1KG reference PCA
data(demoPCASyntheticProfiles)

## Load the known ancestry for the demo 1KG reference profiles
data(demoKnownSuperPop1KG)

pcaSynthetic <- demoPCASyntheticProfiles
pcaSynthetic$sample.id <- pcaSynthetic$sample.id[1]

## The function returns 0L when all parameters are valid
RAIDS:::validateComputeKNNRefSample(listEigenvector=pcaSynthetic,
    listCatPop=c("EAS", "EUR", "AFR", "AMR", "SAS"),
    spRef=demoKnownSuperPop1KG, fieldPopInfAnc="Superpop",
    kList=c(10, 11, 12), pcaList=c(13, 14, 15))


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
