% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{addGDS1KGLDBlock}
\alias{addGDS1KGLDBlock}
\title{Append information associated to ld blocks, as indexes, into the
Population Reference SNV Annotation GDS file}
\usage{
addGDS1KGLDBlock(gds, listBlock, blockName, blockDesc)
}
\arguments{
\item{gds}{an object of class \link[gdsfmt]{gds.class}
(GDS file), an opened Reference Annotation GDS file.}

\item{listBlock}{a \code{array} of integer
representing the linkage disequilibrium block for
each SNV in the in the same order than the variant
in Population reference dataset.}

\item{blockName}{a \code{character} string representing the id of the block.
The blockName should not exist in \'gdsRefAnnotFile\'.}

\item{blockDesc}{a \code{character} string representing the description of
the block.}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function appends the information about the ld blocks into
the Population Reference SNV Annotation GDS file. The information is
extracted from the parameter listBlock.
}
\examples{

## Required library for GDS
library(gdsfmt)
## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

fileAnnotGDS <- file.path(tempdir(), "ex1_good_small_1KG_Ann_GDS.gds")


file.copy(file.path(dataDir, "tests",
    "ex1_NoBlockGene.1KG_Annot_GDS.gds"), fileAnnotGDS)


fileReferenceGDS  <- file.path(dataDir, "tests",
    "ex1_good_small_1KG.gds")
 \donttest{
    gdsRef <- openfn.gds(fileReferenceGDS)
    listBlock <- read.gdsn(index.gdsn(gdsRef, "snp.position"))
    listBlock <- rep(-1, length(listBlock))
    closefn.gds(gdsRef)
    gdsAnnot1KG <- openfn.gds(fileAnnotGDS, readonly=FALSE)
    ## Append information associated to blocks
    RAIDS:::addGDS1KGLDBlock(gds=gdsAnnot1KG,
        listBlock=listBlock,
        blockName="blockEmpty",
        blockDesc="Example")

    closefn.gds(gdsAnnot1KG)

    gdsAnnot1KG <- openfn.gds(fileAnnotGDS)
    print(gdsAnnot1KG)

    closefn.gds(gdsAnnot1KG)
}

## Remove temporary file
unlink(fileAnnotGDS, force=TRUE)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
