% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateStudyDataFrameParameter}
\alias{validateStudyDataFrameParameter}
\title{Validate that the study data set has
the mandatory columns}
\usage{
validateStudyDataFrameParameter(studyDF)
}
\arguments{
\item{studyDF}{a \code{data.frame} containing the study information.
The mandatory columns are:
"study.id", "study.desc", "study.platform". All columns must be in
\code{character} strings (no factor).}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function validates the input dtudy data set.
The study data set
must be a \code{data.frame} with those mandatory columns:
"studyID", "study.desc", "study.platform". All columns must be in
\code{character} strings (no factor).
}
\examples{

## Study data frame
study <- data.frame(study.id = "MYDATA",
                      study.desc = "Description",
                      study.platform = "PLATFORM",
                      stringsAsFactors = FALSE)

## Return 0L when the study data set is valid
RAIDS:::validateStudyDataFrameParameter(studyDF=study)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
