% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG_internal.R
\encoding{UTF-8}
\name{pruning1KGbyChr}
\alias{pruning1KGbyChr}
\title{Extract the pruned SNVs in a population reference data set (ex:1KG)
by chromosome and/or allelic frequency}
\usage{
pruning1KGbyChr(
  gdsReference,
  method = "corr",
  listSamples = NULL,
  slideWindowMaxBP = 5e+05,
  thresholdLD = sqrt(0.1),
  np = 1L,
  verbose = FALSE,
  chr = NULL,
  minAF = NULL,
  outPrefix = "pruned_1KG",
  keepObj = FALSE
)
}
\arguments{
\item{gdsReference}{an object of class
\code{\link[SNPRelate:SNPGDSFileClass]{SNPRelate::SNPGDSFileClass}}, an
opened SNP GDS file.}

\item{method}{a \code{character} string that represents the method that
will be used to calculate the linkage disequilibrium in the
\code{\link[SNPRelate]{snpgdsLDpruning}}() function. The 4 possible values
are: "corr", "r", "dprime" and "composite". Default: \code{"corr"}.}

\item{listSamples}{a \code{character} string that represents the method that
will be used to calculate the linkage disequilibrium in the
\code{\link[SNPRelate]{snpgdsLDpruning}}() function. The 4 possible values
are: "corr", "r", "dprime" and "composite". Default: \code{"corr"}.}

\item{slideWindowMaxBP}{a single positive \code{integer} that represents
the maximum basepairs (bp) in the sliding window. This parameter is used
for the LD pruning done in the \code{runLDPruning}
function. Default: \code{5e5}.}

\item{thresholdLD}{a single \code{numeric} value that represents the LD
threshold used in the \code{runLDPruning} function.
Default: \code{sqrt(0.1)}.}

\item{np}{a single positive \code{integer} specifying the number of
threads to be used. Default: \code{1L}.}

\item{verbose}{a \code{logical} specifying if the function must provide
more information about the process. Default: \code{FALSE}.}

\item{chr}{a \code{character} string representing the chromosome where the
selected SNVs should belong. Only one chromosome can be handled. If
\code{NULL}, the chromosome is not used as a filtering criterion.
Default: \code{NULL}.}

\item{minAF}{a single positive \code{numeric} representing the
minimum allelic frequency used to select the SNVs. If \code{NULL}, the
allelic frequency is not used as a filtering criterion.
Default: \code{NULL}.}

\item{outPrefix}{a \code{character} string that represents the prefix of the
RDS file(s) that will be generated. Default: \code{"pruned_1KG"}.}

\item{keepObj}{a \code{logical} specifying if the function must save the
the processed information into a second RDS file. Default: \code{FALSE}.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
The function extracts the pruned SNVs in a population
reference data set (ex: 1KG) by chromosome and/or allelic frequency.
The pruning is done through the linkage disequilibrium analysis. The
pruned SNVs are saved in a RDS file.
}
\examples{

## Required libraries
library(SNPRelate)
library(gdsfmt)

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## The 1KG Population Reference GDS demo file (opened)
gds1KG <- snpgdsOpen(file.path(dataDir, "PopulationReferenceDemo.gds"))

## The prefix of the RDS file to be created and containing the pruned SNVs
outPrefix <- file.path(tempdir(), "Pruned_Demo_Reference")

## Create a RDS file with the pruned SNVs
RAIDS:::pruning1KGbyChr(gdsReference=gds1KG, outPrefix=outPrefix)

prunedSNVs <- readRDS(file.path(paste0(outPrefix, ".rds")))
prunedSNVs

## Close 1K GDS file
closefn.gds(gds1KG)

## Delete temporary file
unlink(paste0(outPrefix, ".rds"), force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
