% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper.R
\encoding{UTF-8}
\name{generateGDSgenotype}
\alias{generateGDSgenotype}
\title{Add information related to profile genotypes into a Population
Reference GDS file}
\usage{
generateGDSgenotype(gds, pathGeno, fileSNPsRDS, listSamples, verbose)
}
\arguments{
\item{gds}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened Population Reference
GDS file.}

\item{pathGeno}{a \code{character} string representing the path where
the reference genotyping files for each sample are located. The name of the
genotyping files must correspond to
the individual identification (Individual.ID) in the pedigree file.}

\item{fileSNPsRDS}{a \code{character} string representing the path and file
name of the RDS file that contains the indexes of the retained SNPs. The
file must exist. The file must be a RDS file.}

\item{listSamples}{a \code{vector} of \code{character} string corresponding
to profiles (must be the profile identifiers) that will be
retained and added to the Reference GDS file.}

\item{verbose}{a \code{logical} indicating if the function must print
messages when running.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function adds the genotype fields with the associated
information into the Population Reference GDS file for the selected
profiles.
}
\examples{

## Required library
library(gdsfmt)

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Path where the demo genotype CSV files are located
pathGeno <- file.path(dataDir, "demoProfileGenotypes")

## The RDS file containing the pedigree information
pedigreeFile <- file.path(dataDir, "PedigreeReferenceDemo.rds")

## The RDS file containing the indexes of the retained SNPs
snpIndexFile <- file.path(dataDir, "listSNPIndexes_Demo.rds")

## The RDS file containing the filtered SNP information
filterSNVFile <- file.path(dataDir, "mapSNVSelected_Demo.rds")

## Temporary Reference GDS file in temporary directory
tempRefGDS <- file.path(tempdir(), "Ref_TEMP01.gds")

## Create temporary Reference GDS file
newGDS <- createfn.gds(tempRefGDS)
put.attr.gdsn(newGDS$root, "FileFormat", "SNP_ARRAY")

## Read the pedigree file
ped1KG <- readRDS(pedigreeFile)

## Add information about samples to the Reference GDS file
listSampleGDS <- RAIDS:::generateGDSRefSample(gdsReference=newGDS,
                dfPedReference=ped1KG, listSamples=NULL)

## Add SNV information to the Reference GDS
RAIDS:::generateGDSSNPinfo(gdsReference=newGDS, fileFreq=filterSNVFile,
                verbose=FALSE)

## Add genotype information to the Reference GDS
RAIDS:::generateGDSgenotype(gds=newGDS, pathGeno=pathGeno,
        fileSNPsRDS=snpIndexFile, listSamples=listSampleGDS, verbose=FALSE)

## Close file
closefn.gds(newGDS)

## Remove temporary files
unlink(tempRefGDS, force=TRUE)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
