% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper.R
\encoding{UTF-8}
\name{generateGDSSNPinfo}
\alias{generateGDSSNPinfo}
\title{Add information related to SNVs into a Population Reference GDS file}
\usage{
generateGDSSNPinfo(gdsReference, fileFreq, verbose)
}
\arguments{
\item{gdsReference}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened Reference GDS file.}

\item{fileFreq}{a \code{character} string representing the path and file
name of the RDS file with the filtered SNP information.}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function.}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function adds the SNV information into a Population
Reference GDS file.
}
\examples{

## Required package
library(gdsfmt)

## The RDS file containing the filtered SNP information
dataDir <- system.file("extdata", package="RAIDS")
fileFilerterSNVs <- file.path(dataDir, "mapSNVSelected_Demo.rds")

## Temporary Reference GDS file in temporary directory
file1KG <- file.path(tempdir(), "1KG_TEMP_002.gds")
filenewGDS <- createfn.gds(file1KG)

## Add SNV information to Reference GDS
RAIDS:::generateGDSSNPinfo(gdsReference=filenewGDS,
            fileFreq=fileFilerterSNVs, verbose=TRUE)

## Close GDS file (important)
closefn.gds(filenewGDS)

## Remove temporary 1KG_TEMP_002.gds file
unlink(file1KG, force=TRUE)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
