% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtle_load.R
\name{sumstats2qtle}
\alias{sumstats2qtle}
\title{Coerce QTL summary statistics into a QTLExperiment object}
\usage{
sumstats2qtle(
  input,
  feature_id = "gene_id",
  variant_id = "variant_pos",
  betas = "slope",
  errors = "slope_se",
  pvalues = NULL,
  n_max = Inf,
  verbose = TRUE
)
}
\arguments{
\item{input}{Named array or data.frame with state name and the file to the
QTL summary statistics for that state. If data.frame is
provided, it must include columns 'state' and 'path'. Additional
columns will be stored in the colData annotation.}

\item{feature_id}{The name/index of the column with the feature_id info.}

\item{variant_id}{The name/index of the column with the variant_id info.}

\item{betas}{The name/index of the column with the effect size/beta value.}

\item{errors}{The name/index of the column with the effect size/beta standard
error value.}

\item{pvalues}{The name/index of the column with the significance score.}

\item{n_max}{Max number of rows to read per file. This is primarily used
for testing purposes.}

\item{verbose}{logical. Whether to print progress messages.}
}
\value{
A \linkS4class{QTLExperiment} object.
}
\description{
A suite of methods to extract QTL mapping summary statistics from common
QTL workflow output files.
}
\examples{

input_path <- system.file("extdata", package =  "QTLExperiment")
state <- c("lung", "thyroid", "spleen", "blood")

# Input as a named array
input_list <- list(lung = paste0(input_path, "/GTEx_tx_lung.tsv"),
                   spleen = paste0(input_path, "/GTEx_tx_spleen.tsv"))

# Input as a data.frame.
# Must include columns 'state' and 'path'.
input_df <- data.frame(state = c("lung", "spleen"),
                       path = c(paste0(input_path, "/GTEx_tx_lung.tsv"),
                                paste0(input_path, "/GTEx_tx_spleen.tsv")))

# List version
qtle1 <- sumstats2qtle(input_list,
                       feature_id="molecular_trait_id",
                       variant_id="rsid",
                       betas="beta",
                       errors="se",
                       pvalues="pvalue",
                       verbose=TRUE)
qtle1
head(betas(qtle1))

# data.frame version
qtle2 <- sumstats2qtle(input_df,
                       feature_id="molecular_trait_id",
                       variant_id="rsid",
                       betas="beta",
                       errors="se",
                       pvalues="pvalue",
                       verbose=TRUE)
qtle2
head(betas(qtle2))


}
\author{
Christina B Azodi, Amelia Dunstone
}
