% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyCoreGene.R
\name{getCoreGene}
\alias{getCoreGene}
\title{Identify core genes for a list of selected taxa}
\usage{
getCoreGene(rankName, taxaCore, profileDt, taxaCount,
    var1Cutoff = c(0, 1), var2Cutoff = c(0, 1), percentCutoff = c(0, 1),
    coreCoverage = 100, taxDB = NULL)
}
\arguments{
\item{rankName}{working taxonomy rank (e.g. "species", "genus", "family")}

\item{taxaCore}{list of selected taxon names}

\item{profileDt}{dataframe contains the full processed
phylogenetic profiles (see ?fullProcessedProfile or ?parseInfoProfile)}

\item{taxaCount}{dataframe counting present taxa in each supertaxon}

\item{var1Cutoff}{cutoff for var1. Default = c(0, 1).}

\item{var2Cutoff}{cutoff for var2. Default = c(0, 1).}

\item{percentCutoff}{cutoff for percentage of species present in each
supertaxon. Default = c(0, 1).}

\item{coreCoverage}{the least percentage of selected taxa should be
considered. Default = 1.}

\item{taxDB}{Path to the taxonomy DB files}
}
\value{
A list of identified core genes.
}
\description{
Identify core genes for a list of selected (super)taxa. The
identified core genes must be present in at least a certain proportion of
species in each selected (super)taxon (identified via percentCutoff) and
that criteria must be fullfilled for a certain percentage of selected taxa
or all of them (determined via coreCoverage).
}
\examples{
library(dplyr)
data("fullProcessedProfile", package="PhyloProfile")
rankName <- "class"
refTaxon <- "Mammalia"
taxaCore <- c("Mammalia", "Saccharomycetes", "Insecta")
profileDt <- fullProcessedProfile
taxonIDs <- levels(as.factor(fullProcessedProfile$ncbiID))
sortedInputTaxa <- sortInputTaxa(
    taxonIDs, rankName, refTaxon, NULL, NULL
)
taxaCount <- sortedInputTaxa \%>\% dplyr::count(supertaxon)
var1Cutoff <- c(0.75, 1.0)
var2Cutoff <- c(0.75, 1.0)
percentCutoff <- c(0.0, 1.0)
coreCoverage <- 100
getCoreGene(
    rankName,
    taxaCore,
    profileDt,
    taxaCount,
    var1Cutoff, var2Cutoff,
    percentCutoff, coreCoverage
)
}
\seealso{
\code{\link{parseInfoProfile}} for creating a full processed
profile dataframe
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
