% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadData.R
\name{load_data}
\alias{load_data}
\title{Load real-world proteomics data into a SummarizedExperiment}
\usage{
load_data(
  data,
  md,
  protein_column = "Protein.IDs",
  gene_column = "Gene.Names",
  ref_samples = NULL,
  batch_column = NULL,
  condition_column = NULL,
  label_column = NULL
)
}
\arguments{
\item{data}{tabular data table with rows = proteins and columns = samples (such as proteinGroups.txt of MaxQuant)}

\item{md}{experimental design table (requires a column named "Column" for the column names of the sample intensities in data)}

\item{protein_column}{name of the column in data containing the protein IDs}

\item{gene_column}{name of the column in data containing the gene names}

\item{ref_samples}{reference samples if TMT experiment provided (names of samples)}

\item{batch_column}{name of the column in md defining the batches}

\item{condition_column}{name of the column in md defining the condition (can still be changed afterwards)}

\item{label_column}{name of the column in md containing simple sample names (for visualization)}
}
\value{
SummarizedExperiment object
}
\description{
Load real-world proteomics data into a SummarizedExperiment
}
\examples{
data_path <- readPRONE_example("tuberculosis_protein_intensities.csv")
md_path <- readPRONE_example("tuberculosis_metadata.csv")
data <- read.csv(data_path)
md <- read.csv(md_path)
md$Column <- stringr::str_replace_all(md$Column, " ", ".")
ref_samples <- md[md$Group == "ref",]$Column
se <- load_data(data, md, protein_column = "Protein.IDs",
               gene_column = "Gene.names", ref_samples = ref_samples,
               batch_column = "Pool", condition_column = "Group",
               label_column = "Label")

}
