% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEIntersection.R
\name{extract_consensus_DE_candidates}
\alias{extract_consensus_DE_candidates}
\title{Extract consensus DE candidates}
\usage{
extract_consensus_DE_candidates(
  de_res,
  ain = NULL,
  comparisons = NULL,
  norm_thr = 0.8,
  per_comparison = FALSE
)
}
\arguments{
\item{de_res}{data table resulting of run_DE}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in de_res)}

\item{comparisons}{Vector of comparisons (must be valid comparisons saved in de_res)}

\item{norm_thr}{Threshold for the number of normalization methods that must agree on a DE candidate}

\item{per_comparison}{Logical indicating if the consensus should be calculated per comparison}
}
\value{
data table with consensus DE candidates
}
\description{
Extract consensus DE candidates
}
\examples{
data(tuberculosis_TMT_de_res)
extract_consensus_DE_candidates(tuberculosis_TMT_de_res, ain = NULL,
                  comparisons = NULL, norm_thr = 0.8, per_comparison = TRUE)

}
