% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OncoScore.R
\name{compute.oncoscore.from.region}
\alias{compute.oncoscore.from.region}
\title{compute.oncoscore.from.region}
\usage{
compute.oncoscore.from.region(
  chromosome,
  start = NA,
  end = NA,
  gene.num.limit = 100,
  filter.threshold = NA,
  analysis.mode = "Log2",
  cutoff.threshold = 21.09,
  file = NULL
)
}
\arguments{
\item{chromosome}{chromosome to be retireved}

\item{start}{initial position to be used}

\item{end}{final position to be used}

\item{gene.num.limit}{A limit to the genes to be considered in the analysis; this is done to limit the number of queries to PubMed}

\item{filter.threshold}{threshold to filter for a minimum number of citations for the genes}

\item{analysis.mode}{logaritmic scores to be computed, i.e., log10, log2, natural log or log5}

\item{cutoff.threshold}{threshold to be used to asses the oncogenes}

\item{file}{should I save the results to text files?}
}
\value{
the computed scores
}
\description{
Perform OncoScore analysis on a given chromosomic region
}
\examples{
chromosome = 15
start = 200000
end = 300000

}
