% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methy_to_bsseq.R
\name{methy_to_bsseq}
\alias{methy_to_bsseq}
\title{Create BSSeq object from methylation tabix file}
\usage{
methy_to_bsseq(methy, out_folder = tempdir(), verbose = TRUE)
}
\arguments{
\item{methy}{the NanoMethResult object or path to the methylation tabix file.}

\item{out_folder}{the folder to store intermediate files. One file is created
for each sample and contains columns "chr", "pos", "total" and
"methylated".}

\item{verbose}{TRUE if progress messages are to be printed}
}
\value{
a BSSeq object.
}
\description{
Create BSSeq object from methylation tabix file
}
\examples{
nmr <- load_example_nanomethresult()
bsseq <- methy_to_bsseq(nmr)
}
