% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_nsize.R
\name{compute_nsize}
\alias{compute_nsize}
\title{Check for N column if not present and user wants, impute N based on user's
sample size. \strong{NOTE} this will be the same value for each SNP which is not
necessarily correct and may cause issues down the line. N can also be
inputted with "ldsc", "sum", "giant" or "metal" by passing one or
multiple of these.}
\usage{
compute_nsize(
  sumstats_dt,
  imputation_ind = FALSE,
  compute_n = c("ldsc", "giant", "metal", "sum"),
  standardise_headers = FALSE,
  force_new = FALSE,
  return_list = TRUE
)
}
\arguments{
\item{sumstats_dt}{data table obj of the summary statistics file for the
GWAS.}

\item{imputation_ind}{Binary Should a column be added for each imputation
step to show what SNPs have imputed values for differing fields. This
includes a field denoting SNP allele flipping (flipped). \strong{Note}
these columns will be in the formatted summary statistics returned. Default
is FALSE.}

\item{compute_n}{How to compute per-SNP sample size (new column "N").
\itemize{
\item{\code{0}: }{N will not be computed.}
\item{\code{>0}: }{If any number >0 is provided,
that value will be set as N for every row.
\strong{Note}: Computing N this way is incorrect and should be avoided
if at all possible.}
\item{\code{"sum"}: }{N will be computed as:
cases (N_CAS) + controls (N_CON), so long as both columns are present}.
\item{\code{"ldsc"}: }{N will be computed as effective sample size:
Neff =(N_CAS+N_CON)*(N_CAS/(N_CAS+N_CON)) / mean((N_CAS/(N_CAS+N_CON))(N_CAS+N_CON)==max(N_CAS+N_CON))}.
\item{\code{"giant"}: }{N will be computed as effective sample size:
Neff = 2 / (1/N_CAS + 1/N_CON)}.
\item{\code{"metal"}: }{N will be computed as effective sample size:
Neff = 4 / (1/N_CAS + 1/N_CON)}.
}}

\item{standardise_headers}{Standardise headers first.}

\item{force_new}{If "Neff" (or "N") already exists in \code{sumstats_dt},
replace it with the recomputed version.}

\item{return_list}{Return the \code{sumstats_dt} within a named list
(default: \code{TRUE}).}
}
\value{
\code{list("sumstats_dt"=sumstats_dt)}
}
\description{
Check for N column if not present and user wants, impute N based on user's
sample size. \strong{NOTE} this will be the same value for each SNP which is not
necessarily correct and may cause issues down the line. N can also be
inputted with "ldsc", "sum", "giant" or "metal" by passing one or
multiple of these.
}
\examples{
sumstats_dt <- MungeSumstats::formatted_example()
sumstats_dt2 <- MungeSumstats::compute_nsize(sumstats_dt=sumstats_dt,
                                             compute_n=10000)
}
