% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEresultGroupPerTime.R
\name{DEresultGroupPerTime}
\alias{DEresultGroupPerTime}
\title{Intermediate analysis when samples belong to different
biological conditions and different time points.}
\usage{
DEresultGroupPerTime(
  DESeq.result,
  LRT.supp.info = TRUE,
  pval.min = 0.05,
  log.FC.min = 1
)
}
\arguments{
\item{DESeq.result}{Output from the function
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}.}

\item{LRT.supp.info}{\code{TRUE} or \code{FALSE}.
If \code{TRUE}, the algorithm realizes another statistical test in order
to detect if, among all biological conditions and/or times, at least one has
a different behavior than the others (see the input \code{test} in
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}).}

\item{pval.min}{Numeric value between 0 and 1. A gene will be considered as
differentially expressed (DE) between two biological conditions if its
Benjamini-Hochberg adjusted p-value
(see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the threshold \code{pval.min}. Default value is 0.05.}

\item{log.FC.min}{Non negative numeric value.
If the log2 fold change between biological conditions or times has
an absolute value below the threshold \code{log.FC.min},
then the gene is not selected even if is considered as DE.
Default value is 1.
If \code{log.FC.min=0}, all DE genes will be kept.}
}
\value{
The function returns the same DESeqDataSet class object
\code{DESeq.result} with the following results,
saved in the metadata \code{DEresultsTimeGroup} of \code{DESeq.result}:
\itemize{
\item a data.frame (output \code{DEsummary} of \code{DEresultsTimeGroup})
which contains
\itemize{
\item pvalues, log2 fold change and DE genes between each pairs
of biological conditions for a fixed time ti
(except the reference time t0).
\item DE specific genes per biological condition for a fixed time ti
(except the reference time t0).
}
\item inputs for the functions :
\code{\link[=DEplotBarplot]{DEplotBarplot()}},
\code{\link[=DEplotBarplotTime]{DEplotBarplotTime()}},
\code{\link[=DEplotVennBarplotGroup]{DEplotVennBarplotGroup()}},
\code{\link[=DEplotVennBarplotTime]{DEplotVennBarplotTime()}},
\code{\link[=DEplotBarplotFacetGrid]{DEplotBarplotFacetGrid()}},
\code{\link[=DEplotAlluvial]{DEplotAlluvial()}}.
}
}
\description{
This function realizes the intermediate steps of the analysis
of the function \code{\link[=DEanalysisTimeAndGroup]{DEanalysisTimeAndGroup()}}.
}
\examples{
data("RawCounts_Schleiss2021_CLLsub500")
## We take only the first three times (both group) for the speed of
## the example
Index3t<-c(2:4,11:13,20:22, 29:31,38:40,47:49)
RawCounts_3t<-RawCounts_Schleiss2021_CLLsub500[seq_len(200), c(1,Index3t)]

## Preprocessing step
resDATAprepSEleuk <- DATAprepSE(RawCounts=RawCounts_3t,
                                Column.gene=1,
                                Group.position=2,
                                Time.position=4,
                                Individual.position=3)

DESeq2preprocess <- S4Vectors::metadata(resDATAprepSEleuk)$DESeq2obj
DESeq2obj <- DESeq2preprocess$DESeq2preproceesing

##------------------------------------------------------------------------##
dds.DE <- DESeq2::DESeq(DESeq2obj)
##
res.G.T.2 <- DEresultGroupPerTime(DESeq.result=dds.DE,
                                  LRT.supp.info=FALSE,
                                  log.FC.min=1,
                                  pval.min=0.05)
}
\seealso{
The output of the function are used by the main function
\code{\link[=DEanalysisTimeAndGroup]{DEanalysisTimeAndGroup()}}.
}
