% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DATAnormalization.R
\name{DATAnormalization}
\alias{DATAnormalization}
\title{Normalization of raw counts (Main Function).}
\usage{
DATAnormalization(
  SEres,
  Normalization = "vst",
  Blind.rlog.vst = FALSE,
  Plot.Boxplot = TRUE,
  Colored.By.Factors = FALSE,
  Color.Group = NULL,
  Plot.genes = FALSE,
  path.result = NULL,
  Name.folder.norm = NULL
)
}
\arguments{
\item{SEres}{Results of the function
\code{\link[=DATAprepSE]{DATAprepSE()}}.}

\item{Normalization}{"rle", "vst", "rlog" and "rpkm".
"rle", "vst" and "rlog" correspond to a method of normalization proposed
by \code{DESeq2} (see
\code{\link[BiocGenerics:dge]{BiocGenerics::estimateSizeFactors()}} for "rle",
\code{\link[DESeq2:rlog]{DESeq2::rlog()}} for "rlog" and
\code{\link[DESeq2:vst]{DESeq2::vst()}} for "vst").
"rpkm" corresponds to a RPKM normalization after a "rle" normalization.}

\item{Blind.rlog.vst}{\code{TRUE} or \code{FALSE}. \code{FALSE} by default.
See input 'blind' in
\code{\link[DESeq2:rlog]{DESeq2::rlog()}}.
It is recommended to set \code{Blind.rlog.vst=FALSE}
for downstream analysis.}

\item{Plot.Boxplot}{\code{TRUE} or \code{FALSE}. \code{TRUE} by default.
If \code{Plot.Boxplot=TRUE}, the function
\code{\link[=DATAplotBoxplotSamples]{DATAplotBoxplotSamples()}} will be
called and boxplots will be plotted. Otherwise, no boxplots will be plotted.}

\item{Colored.By.Factors}{\code{TRUE} or \code{FALSE}.
\code{FALSE} by default.
If \code{TRUE}, boxplots will be colored with different colors for different
time measurements (if data were collected at different time points).
Otherwise, boxplots will be colored with different colors for different
biological conditions.}

\item{Color.Group}{\code{NULL} or a data.frame with \eqn{N_{bc}} rows and
two columns where \eqn{N_{bc}} is the number of biological conditions.
\code{NULL} by default.
If \code{Color.Group} is a data.frame, the first column must contain
the name of each biological condition and the second column must contain
the colors associated to each biological condition.
If \code{Color.Group=NULL}, the function will automatically attribute a
color for each biological condition.
If samples belong to different time points only,
\code{Color.Group} will not be used.}

\item{Plot.genes}{\code{TRUE} or \code{FALSE}. \code{FALSE} by default.
If \code{TRUE}, points representing gene expressions
(normalized or raw counts) will be plotted for each sample.
Otherwise, only boxplots will be plotted.}

\item{path.result}{Character or \code{NULL}. \code{NULL} by default.
Path to save all results.
If \code{path.result} contains a sub folder entitled
"1_Normalization_\code{Name.folder.norm}"
all results will be saved in the sub folder
"1_Normalization_\code{Name.folder.norm}".
Otherwise, a sub folder entitled "1_Normalization_\code{Name.folder.norm}"
will be created in \code{path.result} and all results will be saved in
"1_Normalization_\code{Name.folder.norm}".
If \code{NULL}, the results will not be saved in a folder.
\code{NULL} as default.}

\item{Name.folder.norm}{Character or \code{NULL}. \code{NULL} by default.
If \code{Name.folder.norm} is a character,
the folder name which will contain the results will be
"1_Normalization_\code{Name.folder.norm}".
Otherwise, the folder name will be "1_Normalization".}
}
\value{
The function returns a SummarizedExperiment object (\code{SEresNorm})
identical as \code{SEres} but
\itemize{
\item with the normalized count data saved in \code{assays(SEresNORM)[[2]]}
\item with the boxplot of normalized count
saved in the metadata \code{Results[[1]][[1]]} of \code{SEresNorm}.
}

The boxplot is plotted if \code{Plot.Boxplot=TRUE}.
}
\description{
From raw counts, this function realizes one of
the three methods of normalization of the package \code{DESeq2}:
\itemize{
\item Relative Log Expression (rle) transformation
(see \code{\link[BiocGenerics:dge]{BiocGenerics::estimateSizeFactors()}})
\item Regularized Log (rlog) transformation
(see \code{\link[DESeq2:rlog]{DESeq2::rlog()}})
\item Variance Stabilizing Transformation (vst) transformation
(see \code{\link[DESeq2:vst]{DESeq2::vst()}})
}
}
\details{
All results are built from the results of the function
\code{\link[=DATAprepSE]{DATAprepSE()}}.
}
\examples{
data(RawCounts_Antoszewski2022_MOUSEsub500)
##------------------------------------------------------------------------##
resDATAprepSE <- DATAprepSE(RawCounts=RawCounts_Antoszewski2022_MOUSEsub500,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=NULL,
                            Individual.position=2)
##------------------------------------------------------------------------##
resNorm <- DATAnormalization(SEres=resDATAprepSE,
                             Normalization="rle",
                             Plot.Boxplot=TRUE,
                             Colored.By.Factors=TRUE)
}
\seealso{
The \code{\link[=DATAnormalization]{DATAnormalization()}}
function calls our R function
\code{\link[=DATAprepSE]{DATAprepSE()}},
and the R functions
\code{\link[BiocGenerics:dge]{BiocGenerics::estimateSizeFactors()}},
\code{\link[DESeq2:rlog]{DESeq2::rlog()}} and
\code{\link[DESeq2:vst]{DESeq2::vst()}}
in order to realized the normalization.
}
