% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackendSql-functions.R, R/MsBackendSql.R
\name{MsBackendSql}
\alias{MsBackendSql}
\alias{createMsBackendSqlDatabase}
\alias{MsBackendSql-class}
\alias{backendMerge,MsBackendOfflineSql-method}
\alias{dataStorage,MsBackendOfflineSql-method}
\alias{dbconn,MsBackendOfflineSql-method}
\alias{filterDataOrigin,MsBackendOfflineSql-method}
\alias{filterMsLevel,MsBackendOfflineSql-method}
\alias{filterPrecursorMzRange,MsBackendOfflineSql-method}
\alias{filterPrecursorMzValues,MsBackendOfflineSql-method}
\alias{filterRt,MsBackendOfflineSql-method}
\alias{peaksData,MsBackendOfflineSql-method}
\alias{peaksVariables,MsBackendOfflineSql-method}
\alias{reset,MsBackendOfflineSql-method}
\alias{show,MsBackendOfflineSql-method}
\alias{spectraData,MsBackendOfflineSql-method}
\alias{supportsSetBackend,MsBackendOfflineSql-method}
\alias{tic,MsBackendOfflineSql-method}
\alias{uniqueMsLevels,MsBackendOfflineSql-method}
\alias{intensity,MsBackendOfflineSql-method}
\alias{mz,MsBackendOfflineSql-method}
\alias{longForm,MsBackendOfflineSql-method}
\alias{show,MsBackendSql-method}
\alias{backendInitialize,MsBackendSql-method}
\alias{dataStorage,MsBackendSql-method}
\alias{[,MsBackendSql-method}
\alias{extractByIndex,MsBackendSql,ANY-method}
\alias{peaksData,MsBackendSql-method}
\alias{peaksVariables,MsBackendSql-method}
\alias{intensity,MsBackendSql-method}
\alias{intensity<-,MsBackendSql-method}
\alias{mz,MsBackendSql-method}
\alias{mz<-,MsBackendSql-method}
\alias{$<-,MsBackendSql-method}
\alias{spectraData,MsBackendSql-method}
\alias{reset,MsBackendSql-method}
\alias{spectraNames,MsBackendSql-method}
\alias{spectraNames<-,MsBackendSql-method}
\alias{filterMsLevel,MsBackendSql-method}
\alias{filterRt,MsBackendSql-method}
\alias{filterDataOrigin,MsBackendSql-method}
\alias{filterPrecursorMzRange,MsBackendSql-method}
\alias{filterPrecursorMzValues,MsBackendSql-method}
\alias{uniqueMsLevels,MsBackendSql-method}
\alias{backendMerge,MsBackendSql-method}
\alias{precScanNum,MsBackendSql-method}
\alias{centroided,MsBackendSql-method}
\alias{smoothed,MsBackendSql-method}
\alias{tic,MsBackendSql-method}
\alias{supportsSetBackend,MsBackendSql-method}
\alias{backendBpparam,MsBackendSql-method}
\alias{dbconn,MsBackendSql-method}
\alias{longForm,MsBackendSql-method}
\title{\code{Spectra} MS backend storing data in a SQL database}
\usage{
MsBackendSql()

createMsBackendSqlDatabase(
  dbcon,
  x = character(),
  backend = MsBackendMzR(),
  chunksize = 10L,
  blob = TRUE,
  peaksStorageMode = c("blob2", "long", "blob"),
  partitionBy = c("none", "spectrum", "chunk"),
  partitionNumber = 10L
)

\S4method{show}{MsBackendSql}(object)

\S4method{backendInitialize}{MsBackendSql}(object, dbcon, data, ...)

\S4method{dataStorage}{MsBackendSql}(object)

\S4method{[}{MsBackendSql}(x, i, j, ..., drop = FALSE)

\S4method{extractByIndex}{MsBackendSql,ANY}(object, i)

\S4method{peaksData}{MsBackendSql}(object, columns = c("mz", "intensity"))

\S4method{peaksVariables}{MsBackendSql}(object)

\S4method{intensity}{MsBackendSql}(object)

\S4method{intensity}{MsBackendSql}(object) <- value

\S4method{mz}{MsBackendSql}(object)

\S4method{mz}{MsBackendSql}(object) <- value

\S4method{$}{MsBackendSql}(x, name) <- value

\S4method{spectraData}{MsBackendSql}(object, columns = spectraVariables(object))

\S4method{reset}{MsBackendSql}(object)

\S4method{spectraNames}{MsBackendSql}(object)

\S4method{spectraNames}{MsBackendSql}(object) <- value

\S4method{filterMsLevel}{MsBackendSql}(object, msLevel = uniqueMsLevels(object))

\S4method{filterRt}{MsBackendSql}(object, rt = numeric(), msLevel. = integer())

\S4method{filterDataOrigin}{MsBackendSql}(object, dataOrigin = character())

\S4method{filterPrecursorMzRange}{MsBackendSql}(object, mz = numeric())

\S4method{filterPrecursorMzValues}{MsBackendSql}(object, mz = numeric(), ppm = 20, tolerance = 0)

\S4method{uniqueMsLevels}{MsBackendSql}(object, ...)

\S4method{backendMerge}{MsBackendSql}(object, ...)

\S4method{precScanNum}{MsBackendSql}(object)

\S4method{centroided}{MsBackendSql}(object)

\S4method{smoothed}{MsBackendSql}(object)

\S4method{tic}{MsBackendSql}(object, initial = TRUE)

\S4method{supportsSetBackend}{MsBackendSql}(object, ...)

\S4method{backendBpparam}{MsBackendSql}(object, BPPARAM = bpparam())

\S4method{dbconn}{MsBackendSql}(x)

\S4method{longForm}{MsBackendSql}(object, columns = spectraVariables(object))
}
\arguments{
\item{dbcon}{Connection to a database.}

\item{x}{For \code{createMsBackendSqlDatabase()}: \code{character} with the names of
the raw data files from which the data should be imported. For other
methods an \code{MsqlBackend} instance.}

\item{backend}{For \code{createMsBackendSqlDatabase()}: MS backend that can be
used to import MS data from the raw files specified with
parameter \code{x}.}

\item{chunksize}{For \code{createMsBackendSqlDatabase()}: \code{integer(1)} defining
the number of input that should be processed per iteration. With
\code{chunksize = 1} each file specified with \code{x} will be imported and its
data inserted to the database. With \code{chunksize = 5} data from 5 files
will be imported (in parallel) and inserted to the database. Thus,
higher values might result in faster database creation, but require
also more memory.}

\item{blob}{For \code{createMsBackendSqlDatabase()}, \code{setBackend()}:
\code{logical(1)} whether individual m/z and intensity values should be
stored separately (\code{blob = FALSE}) or if the peaks data should be
stored as data type \emph{BLOB} into the database (\code{blob = TRUE}, the
default). See also parameter \code{peaksStorageMode} for different data
storage options.}

\item{peaksStorageMode}{\code{character(1)} defining how peaks variables are
stored in the database. The default \code{peaksStorageMode = "blob2"} stores
the full peaks matrix of each spectrum as data type \emph{BLOB} as one entry
into a single database table column. \code{peaksStorageMode = "blob"} stores
in contrast the m/z and intensity vectors as separate BLOB types into
two database tables. \code{peaksStorageMode = "long"} allows to store the
data in \emph{long mode}, i.e. each intensity and m/z value is stored
individually in the database.}

\item{partitionBy}{For \code{createMsBackendSqlDatabase()}: \code{character(1)}
defining if and how the peak data table should be partitioned. \code{"none"}
(default): no partitioning, \code{"spectrum"}: peaks are assigned to the
partition based on the spectrum ID (number), i.e. spectra are evenly
(consecutively) assigned across partitions. For \code{partitionNumber = 3},
the first spectrum is assigned to the first partition, the second to
the second, the third to the third and the fourth spectrum again to
the first partition. \code{"chunk"}: spectra processed as part of the same
\emph{chunk} are placed into the same partition. All spectra from the next
processed chunk are assigned to the next partition. Note that this is
only available for MySQL/MariaDB databases, i.e., if \code{con} is a
\code{MariaDBConnection}.
See details for more information.}

\item{partitionNumber}{For \code{createMsBackendSqlDatabase()}: \code{integer(1)}
defining the number of partitions the database table will be
partitioned into (only supported for MySQL/MariaDB databases).}

\item{object}{A \code{MsBackendSql} instance.}

\item{data}{For \code{backendInitialize()}: optional \code{DataFrame} with the full
spectra data that should be inserted into a (new) \code{MsBackendSql}
database. If provided, it is assumed that \code{dbcon} is a (writeable)
connection to an empty database into which \code{data} should be inserted.
\code{data} could be the output of \code{spectraData} from another backend.}

\item{...}{For \code{[}: ignored. For \code{backendInitialize()}, if parameter \code{data}
is used: additional parameters to be passed to the function creating the
database such as \code{blob} or \code{peaksStorageMode}. For \code{setBackend()}: any
parameters supported by \code{backendInitialize()} or
\code{createMsBackendSqlDatabase()}.}

\item{i}{For \code{[}: \code{integer} or \code{logical} to subset the object.}

\item{j}{For \code{[}: ignored.}

\item{drop}{For \code{[}: \code{logical(1)}, ignored.}

\item{columns}{For \code{spectraData()}: \code{character()} optionally defining a
subset of spectra variables that should be returned. Defaults to
\code{columns = spectraVariables(object)} hence all variables are returned.
For \code{peaksData} accessor: optional \code{character} with requested columns
in the individual \code{matrix} of the returned \code{list}. Defaults to
\code{columns = c("mz", "intensity")} but all columns listed by
\code{peaksVariables} would be supported.}

\item{value}{For all setter methods: replacement value.}

\item{name}{For \verb{<-}: \code{character(1)} with the name of the spectra variable
to replace.}

\item{msLevel}{For \code{filterMsLevel()}: \code{integer} specifying the MS levels to
filter the data.}

\item{rt}{For \code{filterRt()}: \code{numeric(2)} with the lower and upper retention
time. Spectra with a retention time \verb{>= rt[1]} and \verb{<= rt[2]} are
returned.}

\item{msLevel.}{For \verb{filterRt(): }integer\verb{with the MS level(s) on which the retention time filter should be applied (all spectra from other MS levels are considered for the filter and are returned *as is*). If not specified, the retention time filter is applied to all MS levels in}object`.}

\item{dataOrigin}{For \code{filterDataOrigin()}: \code{character} with \emph{data origin}
values to which the data should be subsetted.}

\item{mz}{For \code{filterPrecursorMzRange()}: \code{numeric(2)} with the desired lower
and upper limit of the precursor m/z range.
For \code{filterPrecursorMzValues()}: \code{numeric} with the m/z value(s) to
filter the object.}

\item{ppm}{For \code{filterPrecursorMzValues()}: \code{numeric} with the m/z-relative
maximal acceptable difference for a m/z value to be considered
matching. Can be of length 1 or equal to \code{length(mz)}.}

\item{tolerance}{For \code{filterPrecursorMzValues()}: \code{numeric} with the absolute
difference for m/z values to be considered matching. Can be of length 1
or equal to \code{length(mz)}.}

\item{initial}{For \code{tic()}: \code{logical(1)} whether the original total ion count
should be returned (\code{initial = TRUE}, the default) or whether it
should be calculated on the spectras' intensities (\code{initial = FALSE}).}

\item{BPPARAM}{for \code{backendBpparam()}: \code{BiocParallel} parallel processing
setup. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for more information.}
}
\value{
See documentation of respective function.
}
\description{
The \code{MsBackendSql} is an implementation for the \code{\link[Spectra:MsBackend]{Spectra::MsBackend()}} class
for \code{\link[Spectra:Spectra]{Spectra::Spectra()}} objects which stores and retrieves MS data from a
SQL database. New databases can be created from raw MS data files using
\code{createMsBackendSqlDatabase()}.
}
\details{
The \code{MsBackendSql} class is principally a \emph{read-only} backend but by
extending the \code{\link[Spectra:MsBackendCached]{Spectra::MsBackendCached()}} backend from the \code{Spectra}
package it allows changing and adding (\strong{temporarily}) spectra variables
\strong{without} changing the original data in the SQL database.
}
\note{
The \code{MsBackendSql} backend keeps an (open) connection to the SQL database
with the data and hence does not support saving/loading of a backend to
disk (e.g. using \code{save} or \code{saveRDS}). Also, for the same reason, the
\code{MsBackendSql} does not support parallel processing. The \code{backendBpparam()}
method for \code{MsBackendSql} will thus always return a
\code{\link[BiocParallel:SerialParam-class]{BiocParallel::SerialParam()}} object.

The \code{\link[=MsBackendOfflineSql]{MsBackendOfflineSql()}} could be used as an alternative as it supports
saving/loading the data to/from disk and supports also parallel processing.
}
\section{Creation of backend objects}{


New backend objects can be created with the \code{MsBackendSql()} function.
SQL databases can be created and filled with MS data from raw data files
using the \code{createMsBackendSqlDatabase()} function or using
\code{backendInitialize()} and providing all data with parameter \code{data}. In
addition it is possible to create a database from a \code{Spectra} object
changing its backend to a \code{MsBackendSql} or \code{MsBackendOfflineSql} using
the \code{\link[Spectra:Spectra]{Spectra::setBackend()}} function.
Existing SQL databases (created previously with
\code{createMsBackendSqlDatabase()} or \code{backendInitialize()} with the \code{data}
parameter) can be loaded using the \emph{conventional} way to create/initialize
\code{MsBackend} classes, i.e. using \code{backendInitialize()}.
\itemize{
\item \code{createMsBackendSqlDatabase()}: create a database and fill it with MS data.
Parameter \code{dbcon} is expected to be a database connection, parameter \code{x}
a \code{character} vector with the file names from which to import the data.
Parameter \code{backend} is used for the actual data import and defaults to
\code{backend = MsBackendMzR()} hence allowing to import data from mzML, mzXML
or netCDF files. Parameter \code{chunksize} allows to define the number of
files (\code{x}) from which the data should be imported in one iteration. With
the default \code{chunksize = 10L} data is imported from 10 files in \code{x} at
the same time (if \code{backend} supports it even in parallel) and this data
is then inserted into the database. Larger chunk sizes will require more
memory and also larger disk space (as data import is performed through
temporary files) but might eventually be faster. Parameter \code{blob} allows
to define whether m/z and intensity values from a spectrum should be
stored as a \emph{BLOB} SQL data type in the database (\code{blob = TRUE}, the
default) or if individual m/z and intensity values for each peak should
be stored separately (\code{blob = FALSE}). The latter case results in a much
larger database and slower performance of the \code{peaksData} function, but
would allow to define custom (manual) SQL queries on individual peak
values. For \code{blob = TRUE}, the peaks data can be stored in two different
ways which can be selected with the additional parameter
\code{peaksStorageMode}. The default \code{peaksStorageMode = "blob2"} stores the
full peaks matrix of a spectrum as a single entry to the database (into a
single database table column) while \code{peaksStorageMode = "blob"} (which
was the default until version 1.7.2) stores the m/z and intensity
vectors as BLOB data type into two separate database table columns.
Performance for \code{peaksData()} is thus about twice as fast for
\code{peaksStorageMode = "blob2"}.
While data can be stored in any SQL database, at present it is suggested
to use MySQL/MariaDB databases. For \code{dbcon} being a connection to a
MySQL/MariaDB database, the tables will use the \emph{ARIA} engine providing
faster data access and will use \emph{table partitioning}: tables are
splitted into multiple partitions which can improve data insertion and
index generation. Partitioning can be defined with the parameters
\code{partitionBy} and \code{partitionNumber}. By default \code{partitionBy = "none"}
no partitioning is performed. For \code{blob = TRUE} partitioning is usually
not required. Only for \code{blob = FALSE } and very large datasets it is
suggested to enable table partitioning by selecting either
\code{partitionBy = "spectrum"} or \code{partitionBy = "chunk"}. The first option
assignes consecutive spectra to different partitions while the latter
puts spectra from files part of the same \emph{chunk} into the same partition.
Both options have about the same performance but
\code{partitionBy = "spectrum"} requires less disk space.
Note that, while inserting the data takes a considerable amount of
time, also the subsequent creation of database indices can take very
long (even longer than data insertion for \code{blob = FALSE}).
\item \code{backendInitialize()}: get access and initialize a \code{MsBackendSql} object.
Parameter \code{object} is supposed to be a \code{MsBackendSql} instance, created
e.g. with \code{MsBackendSql()}. Parameter \code{dbcon} is expected to be a
connection to an existing \emph{MsBackendSql} SQL database (created e.g. with
\code{createMsBackendSqlDatabase()}). To initialize a \code{MsBackendOfflineSql()}
all information required for a \code{\link[DBI:dbConnect]{DBI::dbConnect()}} call to connect to a
database need to be provided.
\code{backendInitialize()} can alternatively also be used to create a \strong{new}
\code{MsBackendSql} database using the optional
\code{data} parameter. In this case, \code{dbcon} is expected to be a writeable
connection to an empty database and \code{data} a \code{DataFrame} with the \strong{full}
spectra and peaks data to be inserted into this database. The format of
\code{data} should match the format of the \code{DataFrame} returned by the
\code{spectraData()} function and requires columns \code{"mz"} and \code{"intensity"}
with the m/z and intensity values of each spectrum.
The \code{backendInitialize()} call will then create all necessary tables in
the database, will fill these tables with the provided data and will
return an \code{MsBackendSql} for this database.
The \code{MsBackendSql} and \code{MsBackendOfflineSql} objects
support the \code{\link[Spectra:Spectra]{Spectra::setBackend()}} method from \code{Spectra} to change
from (any) backend to a \code{MsBackendSql}. Any parameters to the
\code{backendInitialize()} function can be passed to \code{setBackend()}. Note
however that chunk-wise (or parallel) processing needs to be disabled
in this case by passing eventually \code{f = factor()} to the \code{setBackend()}
call.
\item \code{supportsSetBackend()}: whether \code{MsBackendSql} supports the \code{setBackend()}
method to change the \code{MsBackend} of a \code{Spectra} object to a
\code{MsBackendSql}. Returns \code{TRUE}, thus, changing the backend to a
\code{MsBackendSql} is supported \strong{if} a writeable database connection
is provided in addition with parameter \code{dbcon} (i.e.
\code{setBackend(sps, MsBackendSql(), dbcon = con)} with \code{con} being a
connection to an \strong{empty} database would store the full spectra
data from the \code{Spectra} object \code{sps} into the specified database and
would return a \code{Spectra} object that uses a \code{MsBackendSql}).
\item \code{backendBpparam()}: whether a \code{MsBackendSql} supports parallel processing.
Takes a \code{MsBackendSql} and a parallel processing setup (see
\code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for details) as input and always returns a
\code{\link[BiocParallel:SerialParam-class]{BiocParallel::SerialParam()}} since
\code{MsBackendSql} does \strong{not} support parallel processing.
\item \code{dbconn()}: returns the connection to the database.
}
}

\section{Subsetting, merging and filtering data}{


\code{MsBackendSql} objects can be subsetted using the \code{[} or \code{extractByIndex()}
functions. Internally, this will simply subset the \code{integer} vector of the
primary keys and eventually cached data. The original data in the database
\strong{is not} affected by any subsetting operation. Any subsetting operation
can be \emph{undone} by resetting the object with the \code{reset()} function.
Subsetting in arbitrary order as well as index replication is supported.

Multiple \code{MsBackendSql} objects can also be merged (combined) with the
\code{backendMerge()} function. Note that this requires that all \code{MsBackendSql}
objects are connected to the \strong{same} database. This function is thus
mostly used for combining \code{MsBackendSql} objects that were previously
splitted using e.g. \code{split()}.

In addition, \code{MsBackendSql} supports all other filtering methods available
through \code{\link[Spectra:MsBackendCached]{Spectra::MsBackendCached()}}. Implementation of filter functions
optimized for \code{MsBackendSql} objects are:
\itemize{
\item \code{filterDataOrigin()}: filter the object retaining spectra with \code{dataOrigin}
spectra variable values matching the provided ones with parameter
\code{dataOrigin}. The function returns the results in the order of the
values provided with parameter \code{dataOrigin}.
\item \code{filterMsLevel()}: filter the object based on the MS levels specified with
parameter \code{msLevel}. The function does the filtering using SQL queries.
If \code{"msLevel"} is a \emph{local} variable stored within the object (and hence
in memory) the default implementation in \code{MsBackendCached} is used
instead.
\item \code{filterPrecursorMzRange()}: filters the data keeping only spectra with a
\code{precursorMz} within the m/z value range provided with parameter \code{mz}
(i.e. all spectra with a precursor m/z \verb{>= mz[1L]} and \verb{<= mz[2L]}).
\item filterPrecursorMzValues()\verb{: filters the data keeping only spectra with precursor m/z values matching the value(s) provided with parameter }mz\verb{. Parameters }ppm\code{and}tolerance\verb{allow to specify acceptable differences between compared values. Lengths of}ppm\code{and}tolerance\verb{can be either}1\verb{or equal to}length(mz)` to use different values for ppm and
tolerance for each provided m/z value.
\item \code{filterRt()}: filter the object keeping only spectra with retention times
within the specified retention time range (parameter \code{rt}). Optional
parameter \code{msLevel.} allows to restrict the retention time filter only
on the provided MS level(s) returning all spectra from other MS levels.
}
}

\section{Accessing and \emph{modifying} data}{


The functions listed here are specifically implemented for \code{MsBackendSql}.
In addition, \code{MsBackendSql} inherits and supports all data accessor,
filtering functions and data manipulation functions from
\code{\link[Spectra:MsBackendCached]{Spectra::MsBackendCached()}}.
\itemize{
\item \code{$}, \verb{$<-}: access or set (add) spectra variables in \code{object}. Spectra
variables added or modified using the \verb{$<-} are \emph{cached} locally within
the object (data in the database is never changed). To restore an object
(i.e. drop all cached values) the \code{reset} function can be used.
\item \code{dataStorage()}: returns a \code{character} vector same length as there are
spectra in \code{object} with the name of the database containing the data.
\item \verb{intensity<-}: not supported.
\item \code{longForm()}: extract the MS data in \emph{long form} as a \code{data.frame}.
Parameter \code{columns} allows to specify the columns (spectra and/or peaks
variables) that should be included in the result. If MS peaks data are
stored in long form in the database (i.e., \code{peaksStorageMode = "long"} is
used), the data is extracted using a dedicated SQL query. Otherwise the
default implementation of the \code{longForm()} method from the \emph{Spectra}
package that is based on the \code{spectraData()} function is used instead.
Note that the performance of the SQL-based \code{longForm()} function is not
necessarily higher than the default implementation, mostly because
data extraction from the database layouts that store the MS peaks data as
\emph{BLOB} datatype (i.e., \code{peaksStorageMode = "blob"} or
\code{peaksStorageMode = "blob2"}) is faster.
\item \verb{mz<-}: not supported.
\item \code{peaksData()}: returns a \code{list} with the spectras' peak data. The length of
the list is equal to the number of spectra in \code{object}. Each element of
the list is a \code{matrix} with columns according to parameter \code{columns}. For
an empty spectrum, a \code{matrix} with 0 rows is returned. Use
\code{peaksVariables(object)} to list supported values for parameter
\code{columns}.
\item \code{peaksVariables()}: returns a \code{character} with the available peak
variables, i.e. columns that could be queried with \code{peaksData()}.
\item \code{reset()}: \emph{restores} an \code{MsBackendSql} by re-initializing it with the
data from the database. Any subsetting or cached spectra variables will
be lost.
\item \code{spectraData()}: gets general spectrum metadata. \code{spectraData()} returns
a \code{DataFrame} with the same number of rows as there are spectra in
\code{object}. Parameter \code{columns} allows to select specific spectra
variables.
\item \code{spectraNames()}, \verb{spectraNames<-}: returns a \code{character} of length equal
to the number of spectra in \code{object} with the primary keys of the spectra
from the database (converted to \code{character}). Replacing spectra names
with \verb{spectraNames<-} is not supported.
\item \code{uniqueMsLevels()}: returns the unique MS levels of all spectra in
\code{object}.
\item \code{tic()}: returns the originally reported total ion count (for
\code{initial = TRUE}) or calculates the total ion count from the intensities
of each spectrum (for \code{initial = FALSE}).
}
}

\section{Implementation notes}{


Internally, the \code{MsBackendSql} class contains only the primary keys for all
spectra stored in the SQL database. Keeping only these \code{integer} in memory
guarantees a minimal memory footpring of the object. Still, depending of
the number of spectra in the database, this \code{integer} vector might become
very large. Any data access will involve SQL calls to retrieve the data
from the database. By extending the \code{\link[Spectra:MsBackendCached]{Spectra::MsBackendCached()}} object
from the \code{Spectra} package, the \code{MsBackendSql} supports to (temporarily,
i.e. for the duration of the R session) add or modify spectra variables.
These are however stored in a \code{data.frame} within the object thus
increasing the memory demand of the object.
}

\examples{

####
## Create a new MsBackendSql database

## Define a file from which to import the data
data_file <- system.file("microtofq", "MM8.mzML", package = "msdata")

## Create a database/connection to a database
library(RSQLite)
db_file <- tempfile()
dbc <- dbConnect(SQLite(), db_file)

## Import the data from the file into the database
createMsBackendSqlDatabase(dbc, data_file)
dbDisconnect(dbc)

## Initialize a MsBackendSql
dbc <- dbConnect(SQLite(), db_file)
be <- backendInitialize(MsBackendSql(), dbc)

be

## Original data source
head(be$dataOrigin)

## Data storage
head(dataStorage(be))

## Access all spectra data
spd <- spectraData(be)
spd

## Available variables
spectraVariables(be)

## Access mz values
mz(be)

## Subset the object to spectra in arbitrary order
be_sub <- be[c(5, 1, 1, 2, 4, 100)]
be_sub

## The internal spectrum IDs (primary keys from the database)
be_sub$spectrum_id_

## Add additional spectra variables
be_sub$new_variable <- "B"

## This variable is *cached* locally within the object (not inserted into
## the database)
be_sub$new_variable
}
\author{
Johannes Rainer
}
