% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_calculations.R
\name{lf_model}
\alias{lf_model}
\title{Main LF modeling function for MSstatsShiny application}
\usage{
lf_model(data, contrast.matrix, busy_indicator = TRUE)
}
\arguments{
\item{data}{summarized data from output of MSstats summarization function.}

\item{contrast.matrix}{contrast matrix specifying which conditions should be compared}

\item{busy_indicator}{Boolean indicator indicating whether or not to display
shiny waiting indicator.}
}
\value{
list of LF modeling results
}
\description{
Main LF function to model MSstatsShiny data.
}
\examples{
data("dia_skyline_summarized")
comparison <- matrix(c(1, -1, 0, 0, 0, 0, 0, 0, 0, 0),nrow=1)
row.names(comparison) = "1 vs 128"
colnames(comparison) = c("1", "128", "16", "2", "256", 
                         "32", "4", "512", "64", "8")
model_lf_test = lf_model(dia_skyline_summarized, comparison, 
                         busy_indicator = FALSE)


}
