% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationPlotLiP.R
\name{correlationPlotLiP}
\alias{correlationPlotLiP}
\title{Plot run correlation for provided LiP and TrP experiment.}
\usage{
correlationPlotLiP(
  data,
  method = "pearson",
  value_columns = "INTENSITY",
  x.axis.size = 10,
  y.axis.size = 10,
  legend.size = 10,
  width = 10,
  height = 10,
  address = ""
)
}
\arguments{
\item{data}{output of MSstatsLiP converter function. Must include at least
ProteinName, Run, and Intensity columns}

\item{method}{one of "pearson", "kendall", "spearman". Default is pearson.}

\item{value_columns}{one of "INTENSITY" or "ABUNDANCE". INTENSITY is the raw
data, whereas ABUNDANCE is the log transformed INTENSITY column. INTENSITY is
default.}

\item{x.axis.size}{size of axes labels, e.g. name of the comparisons in
heatmap, and in comparison plot. Default is 10.}

\item{y.axis.size}{size of axes labels, e.g. name of targeted proteins in
heatmap. Default is 10.}

\item{legend.size}{size of legend for color at the bottom of volcano plot.
Default is 10.}

\item{width}{width of the saved file. Default is 10.}

\item{height}{height of the saved file. Default is 10.}

\item{address}{the name of folder that will store the results. Default
folder is the current working directory. The other assigned folder has to
be existed under the current working directory. An output pdf file is
automatically created with the default name of "VolcanoPlot.pdf" or
"Heatmap.pdf". The command address can help to specify where to store the
file as well as how to modify the beginning of the file name. If
address=FALSE, plot will be not saved as pdf file but showed in window}
}
\value{
plot or pdf
}
\description{
Plot run correlation for provided LiP and TrP experiment.
}
\examples{
## Use output of dataSummarizationLiP function
correlationPlotLiP(MSstatsLiP_Summarized, address = FALSE)
}
